% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-methods.R
\name{unblncdTree}
\alias{unblncdTree}
\title{Generate an unbalanced tree}
\usage{
unblncdTree(n, wndmtrx = FALSE, parallel = FALSE)
}
\arguments{
\item{n}{number of tips, integer, must be 3 or greater}

\item{wndmtrx}{T/F add node matrix? Default FALSE.}

\item{parallel}{T/F run in parallel? Default FALSE.}
}
\description{
Returns an unbalanced \code{TreeMan} tree with \code{n}
tips.
}
\details{
Equivalent to \code{ape}'s \code{stree(type='left')} but returns a
\code{TreeMan} tree. Tree is always rooted and bifurcating.
}
\examples{
library(treeman)
tree <- unblncdTree(5)
}
\seealso{
\code{\link{TreeMan-class}}, \code{\link{randTree}},
\code{\link{blncdTree}}
}
