% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-methods.R
\name{setTol}
\alias{setTol}
\title{Set the extinction tolerance}
\usage{
setTol(tree, tol)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{tol}{new tolerance}
}
\description{
Return a tree with the tolerance altered.
}
\details{
Extant tips are determined by how close they are to zero. By default this value
is 1e-8. Using this function to change the tolerance will alter the \code{ext} and \code{exc}
slots.
}
\examples{
library(treeman)
tree <- randTree(10)
tree <- setTol(tree, 10)
print(tree)
}
\seealso{
\code{\link{setNdsSpn}}
\url{https://github.com/DomBennett/treeman/wiki/set-methods}
}

