% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_multilocus.R
\name{get_loci}
\alias{get_loci}
\title{Separate a locus tree into loci}
\usage{
get_loci(locus_tree)
}
\arguments{
\item{locus_tree}{tree of type `phy`}
}
\value{
list of subtrees (with `locus_tree` at the end`)
}
\description{
Separate a locus tree into loci
}
\details{
This separates loci based on node labels "D[A-Z]". This is intended
to be used internally, but should work with other trees where duplications
are marked similarly.
}
\examples{
# first simulate a species tree
mu <- 0.5
lambda <- 1.0
nt <- 6
tr <- sim_stBD(sbr = lambda, sdr = mu, numbsim = 1, n_tips = nt)
# for a locus tree with 100 genes sampled per locus tree
gene_br <- 0.1
gene_dr <- 0.02
transfer_rate <- 0.0
locus_tree <- sim_ltBD(species_tree = tr[[1]],
                  gbr = gene_br,
                  gdr = gene_dr,
                  lgtr = transfer_rate,
                  num_loci = 1)
locus_tree_subtrees <- get_loci(locus_tree[[1]])
}
