% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sim_locustree_bdp}
\alias{sim_locustree_bdp}
\title{Simulates locus tree using constant rate birth-death-transfer process}
\usage{
sim_locustree_bdp(
  species_tree,
  gbr,
  gdr,
  lgtr,
  num_loci,
  transfer_type = "random"
)
}
\arguments{
\item{species_tree}{species tree to simulate along}

\item{gbr}{gene birth rate}

\item{gdr}{gene death rate}

\item{lgtr}{gene transfer rate}

\item{num_loci}{number of locus trees to simulate}

\item{transfer_type}{The type of transfer input. Acceptable options: "cladewise" or "random"}
}
\value{
List of objects of the tree class (as implemented in APE)
}
\description{
Given a species tree simulates a locus or gene family tree along
    the species tree.
}
\details{
Given a species tree will perform a birth-death process coupled with transfer.
The simulation runs along the species tree speciating and going extinct in addition to locus tree birth and deaths.
Thus with parameters set to 0.0 a tree identical to the species tree is returned (it is relabel however).

Transfers are implemented as a birth-death process.
One descendant lineage retains its species identity the other gains a new identity.
At present, two types of transfers are implemented: "random" an "cladewise".
The random transfer mode transfers one randomly chooses a contemporaneous lineage.
Cladewise transfers choose lineages based on relatedness with more closely related lineages being more likely.
}
\examples{
# first simulate a species tree
mu <- 0.5 # death rate
lambda <- 2.0 # birth rate
numb_replicates <- 10
numb_extant_tips <- 4
# simulate trees under the GSA so first simulates a tree with
# numb_extant_tips * 100 tips counting each time we have a tree with 10 tips
# then randomly picks one of those trees

sp_tree <- sim_sptree_bdp(sbr = lambda,
                sdr = mu,
                numbsim = numb_replicates,
                n_tips = numb_extant_tips)

gene_br <- 1.0
gene_dr <- 0.2
transfer_rate <- 0.2
sim_locustree_bdp(species_tree = sp_tree[[1]],
                  gbr = gene_br,
                  gdr = gene_dr,
                  lgtr = transfer_rate,
                  num_loci = 10)
}
\references{
Rasmussen MD, Kellis M. Unified modeling of gene duplication, loss, and
    coalescence using a locus tree. Genome Res. 2012;22(4):755–765.
    doi:10.1101/gr.123901.111
}
