% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed.R
\name{tr_real_yield_curve}
\alias{tr_real_yield_curve}
\title{Return the daily treasury par real yield curve rates}
\usage{
tr_real_yield_curve(date = NULL)
}
\arguments{
\item{date}{\code{character(1)} or \code{numeric(1)} date in format yyyy or yyyymm.
If \code{NULL}, all data is returned. Default \code{NULL}.}
}
\value{
A \code{data.frame()} with columns \code{date}, \code{maturity} and \code{rate} or
\code{NULL} when no entries where found.
}
\description{
Return the daily treasury par real yield curve rates
}
\examples{
\donttest{
# get data for a single month
tr_real_yield_curve("202201")
# or for the entire year
tr_real_yield_curve(2022)
}
}
\references{
\url{https://home.treasury.gov/treasury-daily-interest-rate-xml-feed}
}
\seealso{
Other treasury data: 
\code{\link{tr_bill_rates}()},
\code{\link{tr_long_term_rate}()},
\code{\link{tr_real_long_term}()},
\code{\link{tr_yield_curve}()}
}
\concept{treasury data}
