% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed.R
\name{tr_long_term_rate}
\alias{tr_long_term_rate}
\title{Return the daily treasury long-term rates}
\usage{
tr_long_term_rate(date = NULL)
}
\arguments{
\item{date}{\code{character(1)} or \code{numeric(1)} date in format yyyy or yyyymm.
If \code{NULL}, all data is returned. Default \code{NULL}.}
}
\value{
A \code{data.frame()} with columns \code{date}, \code{rate_type} and \code{rate} or
\code{NULL} when no entries were found.
}
\description{
Return the daily treasury long-term rates
}
\examples{
\donttest{
# get data for a single month
tr_long_term_rate("202201")
# or for the entire year
tr_long_term_rate(2022)
}
}
\references{
\url{https://home.treasury.gov/treasury-daily-interest-rate-xml-feed}
}
\seealso{
Other treasury data: 
\code{\link{tr_bill_rates}()},
\code{\link{tr_real_long_term}()},
\code{\link{tr_real_yield_curve}()},
\code{\link{tr_yield_curve}()}
}
\concept{treasury data}
