% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find-source-in-exprs.R
\name{find_source_in_file}
\alias{find_source_in_file}
\alias{find_source_in_exprs}
\alias{find_source_exprs}
\title{Find Source Text in Expression Tokens}
\usage{
find_source_in_file(
  path = "",
  encoding = "UTF-8",
  strict = TRUE,
  algorithm = constant("algorithms"),
  verbose = FALSE
)

find_source_in_exprs(
  tokens = utils::getParseData(),
  path = "",
  strict = TRUE,
  algorithm = constant("algorithms")
)

find_source_exprs(path = "", encoding = "UTF-8")
}
\arguments{
\item{path}{A non-empty and non-\link[base:NA]{NA} character string. A path to
an \R source script.}

\item{encoding}{A non-empty and non-\link[base:NA]{NA} character string. The
underlying source character encoding. In almost all cases, this should
be UTF-8. Other encodings are internally re-encoded to UTF-8 for
portability.}

\item{strict}{A non-\link[base:NA]{NA} logical value. Should only
\emph{explicit calls}, i.e. \code{transltr::translate()}, be extracted? If \code{FALSE},
calls to \emph{any} such function are extracted regardless of the underlying
namespace, i.e. \code{translate()}.}

\item{algorithm}{A non-empty and non-\link[base:NA]{NA} character string
equal to \code{"sha1"}, or \code{"utf8"}. The algorithm to use when hashing
source information for identification purposes.}

\item{verbose}{A non-\link[base:NA]{NA} logical value. Should progress
information be reported?}

\item{tokens}{A \code{\link[=data.frame]{data.frame}} returned by
\code{\link[utils:getParseData]{utils::getParseData()}}. It must always minimally contain
columns \code{line1}, \code{col1}, \code{line2}, \code{col2}, and \code{text}.}
}
\value{
\code{\link[=find_source_in_file]{find_source_in_file()}} and \code{\link[=find_source_in_exprs]{find_source_in_exprs()}} return a list of
\code{\link{Text}} objects. It may contain duplicated elements, depending
on the extracted contents.

\code{\link[=find_source_exprs]{find_source_exprs()}} returns the same output as \code{\link[utils:getParseData]{utils::getParseData()}}.
However, only \code{expr} tokens are returned.
}
\description{
Find, and extract source text that requires translation from a single file,
or from a set of tokenized \R expressions stemming from \code{\link[=parse]{parse()}}.

\strong{Some arguments listed below are not explicitly validated for efficiency.}
}
\details{
\code{\link[=find_source_in_exprs]{find_source_in_exprs()}} silently skips parsing errors. See \code{\link[=find_source]{find_source()}}
for more information.
}
\seealso{
\code{\link{Text}},
\code{\link[=translate]{translate()}},
\code{\link[=find_source]{find_source()}}
}
\keyword{internal}
