% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trSurvfit.R
\name{trSurvfit}
\alias{trSurvfit}
\title{Estimating survival curves via structural transformation model}
\usage{
trSurvfit(trun, obs, delta = NULL, trans = "linear", plots = FALSE,
  covariate = NULL, control = trSurv.control(), ...)
}
\arguments{
\item{trun}{left truncation time satisfying \code{trun} <= \code{obs}.}

\item{obs}{observed failure time, must be the same length as \code{trun}, might be right-censored.}

\item{delta}{an optional 0-1 vector of censoring indicator (0 = censored, 1 = event) for \code{obs}.
If this vector is not specified, \code{condKendall} assumes no censoring and all observed failure time
denote events.}

\item{trans}{a character string specifying the transformation structure. The following are permitted:
\describe{
  \item{linear}{linear transformation structure,}
  \item{log}{log-linear transformation structure,}
  \item{exp}{exponential transformation structure.}
}}

\item{plots}{an optional logical value; if TRUE, a series of diagnostic plots as well as the survival curve for the observed failure time will be plotted.}

\item{covariate}{an optional logical value; if TRUE, covariates will be included in the output data.frame \code{qind}.}

\item{control}{controls the lower and upper bounds when \code{trans} is an user specified function.}

\item{...}{for future methods.}
}
\value{
The output contains the following components:
\describe{
  \item{Sy}{estimated survival function at the (ordered) observed points.}
  \item{byTau}{a list contains the estimator of transformation parameter:
    \code{par} is the best set of transformation parameter found;
    \code{obj} is the value of the inverse probability weighted Kendall's tau corresponding to 'par'.} 
  \item{byP}{a list contains the estimator of transformation parameter:
    \code{par} is the best set of transformation parameter found;
    \code{obj} is the value of the inverse probability weighted Kendall's tau corresponding to 'par'.}
  \item{qind}{a data frame consists of two quasi-independent variables:
    \code{trun} is the transformed truncation time; 
    \code{obs} is the corresponding uncensored failure time.}
}
}
\description{
\code{trSurvfit} estimates survival curves under dependent truncation and independent censoring via a structural transformation model.
A structural transformation model for a latent, quasi-independent truncation time as a function of the observed dependent truncation time and the event time, and an unknown dependence parameter.
The dependence parameter is chosen to either minimize the absolute value of the restricted inverse probability weighted Kendall's tau or maximize the corresponding p-value.
The marginal distribution for the truncation time and the event time are completely left unspecified.
}
\details{
The structure of the transformation model is of the form:
\deqn{h(U) = (1 + a)^-1 * (h(T) + ah(X)),} where T is the truncation time, X is the observed failure time,
U is the transformed truncation time that is quasi-independent from X and h(.) is a monotonic transformation function.
The condition, T < X, is assumed to be satisfied.
The quasi-independent truncation time, U, is obtained by inverting the test for quasi-independence by either minimizing
the absolute value of the restricted inverse probability weighted Kendall's tau or maximize the corresponding p-value.

At the current version, three transformation structures can be specified. \code{trans = "linear"} corresponds to \deqn{h(X) = 1};
\code{trans = "log"} corresponds to \deqn{h(X) = log(X)};
\code{trans = "exp"} corresponds to \deqn{h(X) = exp(X)}.
}
\examples{
\dontrun{
data(channing, package = "boot")
chan <- subset(channing, sex == "Male" & entry < exit)
fit <- with(chan, trSurvfit(entry, exit, cens))
fit
}
}
\references{
Martin E. and Betensky R. A. (2005), Testing quasi-independence of failure and truncation times via conditional Kendall's tau,
\emph{Journal of the American Statistical Association}, \bold{100} (470): 484-492.

Austin, M. D. and Betensky R. A. (2014), Eliminating bias due to censoring in Kendall's tau estimators for quasi-independence of truncation and failure,
\emph{Computational Statistics & Data Analysis}, \bold{73}: 16-26.

Chiou, S., Austin, M., Qian, J. and Betensky R. A. (2016), Transformation model estimation of survival under dependent truncation and independent censoring, an unpublished manuscript.
}
