% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{TrajsBuild}
\alias{TrajsBuild}
\title{Construct multiple trajectories}
\usage{
TrajsBuild(fileNames, fps = NULL, scale = NULL, spatialUnits = NULL,
  timeUnits = NULL, csvStruct = list(x = 1, y = 2, time = NULL),
  smoothP = 3, smoothN = 41, translateToOrigin = FALSE, rootDir = NULL,
  csvReadFn = utils::read.csv, ...)
}
\arguments{
\item{fileNames}{Vector of the names of CSV files containing trajectory
coordinates. All of the files must have the same columns. All file names
must be unique. If \code{rootDir} is not \code{NULL}, then the file names
are treated as regular expressions.}

\item{fps}{Vector of frames-per-second values corresponding to the
trajectories in \code{fileNames}. If length is 1, it is repeated to
length(fileNames).}

\item{scale}{Vector of scale values corresponding to the trajectories in
\code{fileNames}. May be specified as character expressions (e.g. "1 /
1200") rather than numeric values. If NULL, the trajectories will not be
scaled. If length is 1, it is repeated to length(fileNames).}

\item{spatialUnits}{Abbreviated name of spatial coordinate units after
scaling, e.g. "m".}

\item{timeUnits}{Abbreviated name of temporal units, e.g. "s".}

\item{csvStruct}{A list which identifies the columns in each CSV file which
contain x-, y-, and optionally time-values.}

\item{smoothP}{Filter order to be used for Savitzky-Golay smoothing (see
\code{\link{TrajSmoothSG}})}

\item{smoothN}{Filter length to be used for Savitzky-Golay smoothing (must be
odd, see \code{\link{TrajSmoothSG}})}

\item{translateToOrigin}{If TRUE, the trajectory is translated so that its
starting point is at (0, 0).}

\item{rootDir}{Optional name of a top level directory which contains the CSV
files. If \code{rootDir} is not NULL, the CSV files may be located anywhere
within \code{rootDir} or its sub-directories.}

\item{csvReadFn}{Function used to read the CSV files. Required to accept
arguments \code{filename, ...}, and return a data frame of coordinates, or
a list of multiple data frames (see \code{\link[utils]{read.csv}},
\code{\link[utils]{read.csv2}}).}

\item{...}{Additional arguments passed to \code{csvReadFn}.}
}
\value{
A list of trajectories.
}
\description{
Reads multiple trajectories from files, performs some basic sanity checks on
them, and optionally smooths and scales them. Attempts to collect and report
errors for multiple trajectories in a single call.
}
\details{
For each file name in \code{fileNames}, searches through the folder
\code{rootDir} (unless it's \code{NULL}) to find the file, then reads the
file by calling \code{csvReadFn} to obtain a set of coordinates and
optionally times. A Trajectory is constructed by passing the coordinates to
\code{\link{TrajFromCoords}}, passing in the appropriate \code{fps} value,
and x, y and time column names/indices from \code{csvStruct}. If \code{scale}
is not \code{NULL}, the trajectory is then scaled by calling
\code{\link{TrajScale}}. If \code{smoothP} and \code{smoothN} are not
\code{NULL}, the trajectory is smoothed by calling
\code{\link{TrajSmoothSG}}.
}
\examples{
\dontrun{
# Names of CSV files containing trajectory coordinates
fileNames <- c('xy001.csv', 'xy003.csv', 'xy004.csv')
# The files are all located somewhere under this directory
rootDir <- '.'
# Scale for these files is 1 / pixels per metre
scale <- c('1/1200', '1/1350', '1/1300')
# Files have columns y, x
csvStruct <- list(x = 2, y = 1)
# Apply default smoothing, and the files are formatted as conventional CSV,
# so there's no need to specify csvReadFn
trjs <- TrajsBuild(fileNames, fps = 50, scale = scale, units = "m",
                   csvStruct = csvStruct, rootDir = rootDir)
}

}
\seealso{
\code{\link[utils]{read.csv}}, \code{\link{TrajFromCoords}},
  \code{\link{TrajScale}}, \code{\link{TrajSmoothSG}},
  \code{\link{TrajTranslate}}
}
