% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.trajClusters.R
\name{plot.trajClusters}
\alias{plot.trajClusters}
\title{Plots \code{trajClusters} objects}
\usage{
\method{plot}{trajClusters}(x, sample.size = 5, ask = TRUE, which.plots = NULL, spline = FALSE, ...)
}
\arguments{
\item{x}{object of class \code{trajClusters} as returned by
\code{Step3Cluster}.}

\item{sample.size}{the number of random trajectories to be randomly sampled
from each cluster. Defaults to 5.}

\item{ask}{logical. If TRUE, the user is asked before each plot. Defaults to
TRUE.}

\item{which.plots}{either NULL or a vector of integers. If NULL, every
available plot is displayed. If a vector is supplied, only the corresponding
plots will be displayed.}

\item{spline}{logical. If TRUE, each trajectory will be smoothed using
smoothing splines and the median and mean trajectories will be plotted from
the smoothed trajectories. Defaults to FALSE.}

\item{...}{other parameters to be passed through to plotting functions.}
}
\description{
Up to 5 kinds of plots are currently available: a plot of the
cluster-specific median and mean trajectories, a random sample of
trajectories from each cluster and scatter plots of the measures on which
the clustering was based. When the GAP criterion was used in
\code{Step3Clusters} to determine the optimal number of clusters, a plot of
the GAP statistic as a function of the number of clusters is provided.
}
\examples{
\dontrun{

m = Step1Measures(trajdata, ID = TRUE)
s = Step2Selection(m)
c3 = Step3Clusters(s, nclusters = 3)

plot(c3)

#The pointwise mean trajectories correspond to the third and fourth displayed plots.

c4 = Step3Clusters(s, nclusters = 4)

plot(c4, which.plots = 3:4)

}


}
\seealso{
\code{\link[traj]{Step3Clusters}}
}
