% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{boosting.importance.plot}
\alias{boosting.importance.plot}
\title{boosting.importance.plot}
\usage{
boosting.importance.plot(model, col = "steelblue")
}
\arguments{
\item{model}{fitted model object of class adabag.prmdt or boosting.}

\item{col}{the color of the chart bars.}
}
\value{
A ggplot object.
}
\description{
Function that graphs the importance of the variables for a boosting model.
}
\note{
With this function we can identify how important the variables are for the generation of a predictive model.
}
\examples{

data <- iris
n <- nrow(data)
sam <- sample(1:n,n*0.75)
training <- data[sam,]
testing <- data[-sam,]
model <- train.adabag(formula = Species~.,data = training,minsplit = 2,
 maxdepth = 30, mfinal = 10)
boosting.importance.plot(model)

}
\seealso{
\code{\link[ggplot2]{ggplot}}, \code{\link[traineR]{train.adabag}}, \code{\link[adabag]{boosting}}
}
