% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.trafo.R
\name{as.data.frame.trafo}
\alias{as.data.frame.trafo}
\title{Data frame with transformed variables}
\usage{
\method{as.data.frame}{trafo}(x, row.names = NULL, optional = FALSE,
  std = FALSE, ...)
}
\arguments{
\item{x}{an object of type \code{trafo}.}

\item{row.names}{NULL or a character vector giving the row names for the 
data frame. Missing values are not allowed.}

\item{optional}{logical. If TRUE, setting row names and converting column 
names (to syntactic names: see make.names) is optional. Note that all of R's 
base package as.data.frame() methods use optional only for column names 
treatment, basically with the meaning of 
data.frame(*, check.names = !optional)}

\item{std}{logical. If \code{TRUE}, the data is transformed by the 
standardized/scaled transformation. Defaults to \code{FALSE}.}

\item{...}{other parameters that can be passed to the function.}
}
\value{
A data frame with the original variables and the transformed variable.
}
\description{
The data frame that is returned contains the variables that are used
in the model and additionally a variable with the transformed dependent
variable. To the variable name of the dependent variable a t is added for
transformed.
}
\examples{
# Load data
data("cars", package = "datasets")

# Fit linear model
lm_cars <- lm(dist ~ speed, data = cars)

# Transform dependent variable using divergence minimization following
# Kolmogorov-Smirnov
logshiftopt_trafo <- logshiftopt(object = lm_cars, method = "div.ks", 
plotit = FALSE)

# Get a data frame with the added transformed variable
as.data.frame(logshiftopt_trafo)
}
\seealso{
\code{\link{bickeldoksum}}, \code{\link{boxcox}}, \code{\link{dual}}, 
\code{\link{glog}}, \code{\link{gpower}}, \code{\link{log}}, 
\code{\link{logshiftopt}}, \code{\link{manly}}, \code{\link{modulus}}, 
\code{\link{neglog}}, \code{\link{sqrtshift}}, \code{\link{yeojohnson}}
}
