% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{build_network}
\alias{build_network}
\title{Build a road network graph from sf LINESTRING data}
\usage{
build_network(
  roads_sf,
  crs_out = 3857,
  node_intersections = FALSE,
  snap_tol = 0,
  simplify = TRUE
)
}
\arguments{
\item{roads_sf}{An sf object with LINESTRING geometry}

\item{crs_out}{Integer EPSG code for projected CRS}

\item{node_intersections}{Logical; if TRUE, "node" the linework by splitting
at interior intersections/junctions (via `sf::st_union()`), so that crossings
and T-junctions become graph nodes even when they are not endpoints.
This may increase the number of edge segments.}

\item{snap_tol}{Nonnegative numeric; optional snapping tolerance (in projected
CRS units) used to merge nearly identical endpoints. Use 0 to disable.}

\item{simplify}{Logical; if TRUE, remove self-loops and parallel edges.}
}
\value{
A list with components:
\itemize{
  \item roads: cleaned sf object
  \item nodes: sf POINT object with node_id
  \item edges: sf LINESTRING object with from, to, length
  \item graph: igraph object
  \item A: sparse adjacency matrix
}
}
\description{
Build a road network graph from sf LINESTRING data
}
