% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributionProfile.R
\name{distributionProfile}
\alias{distributionProfile}
\title{Generate training distribution profiles.}
\usage{
distributionProfile(object, session = NULL, what = c("speed", "heart.rate"),
  grid = list(speed = seq(0, 12.5, by = 0.05), heart.rate = seq(0, 250)),
  scaled = FALSE, parallel = FALSE, cores = NULL)
}
\arguments{
\item{object}{An object of class \code{\link{trackeRdata}}.}

\item{session}{A numeric vector of the sessions to be used, defaults to all sessions.}

\item{what}{The variables for which the distribution profiles should be generated.}

\item{grid}{A named list containing the grid for the variables in \code{what}.}

\item{scaled}{Logical. Should the distribution profiles be scaled relative to their maximum value?}

\item{parallel}{Logical. Should computation be carried out in parallel?}

\item{cores}{Number of cores for parallel computing. If NULL, the number of cores is set to the value of \code{options("corese")} (on Windows) or \code{options("mc.cores")} (elsewhere), or, if the relevant option is unspecified, to half the number of cores detected.}
}
\value{
An object of class \code{distrProfile}.
}
\description{
Generate training distribution profiles.
}
\examples{
data(run, package = "trackeR")
dProfile <- distributionProfile(run, what = "speed", grid = seq(0, 12.5, by = 0.05))
plot(dProfile, smooth = FALSE)
}
\references{
Kosmidis, I., and Passfield, L. (2015). Linking the Performance of
    Endurance Runners to Training and Physiological Effects via Multi-Resolution
    Elastic Net. \emph{ArXiv e-print} arXiv:1506.01388.
}

