% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hits_summary.R
\name{hits_summary_DT}
\alias{hits_summary_DT}
\alias{hits_summary}
\title{Summary of hits per site/category}
\usage{
hits_summary_DT(
  chemical_summary,
  category = "Biological",
  sum_logic = TRUE,
  hit_threshold = 0.1
)

hits_summary(chemical_summary, category, hit_threshold = 0.1, sum_logic = TRUE)
}
\arguments{
\item{chemical_summary}{Data frame from \code{\link{get_chemical_summary}}.}

\item{category}{Character. Either "Biological", "Chemical Class", or "Chemical".}

\item{sum_logic}{Logical. \code{TRUE} sums the EARs in a specified grouping,
\code{FALSE} does not. \code{FALSE} may be better for traditional benchmarks as
opposed to ToxCast benchmarks.}

\item{hit_threshold}{Numeric threshold defining a "hit".}
}
\value{
data frame with with one row per unique site/category combination. The columns
are site, category, Samples with Hits, and Number of Samples.

data frame with columns "Hits per Sample", "Individual Hits",
"nSample", "site", and "category"
}
\description{
The \code{hits_summary_DT} (DT option) and \code{hits_summary} (data frame 
option) functions create tables information on the number of 
\code{hit_threshold} exceedances per site for each individual grouping. The 
table has one row per group per site that has \code{hit_threshold} 
exceedances. For example, if "Biological" is the category, and a 
site has EAR levels above the specified \code{hit_threshold} for "DNA 
Binding" and "Nuclear Receptors", that site will have 2 rows of data in this 
table.
}
\details{
For each row, there are 4 columns. Site and category (as defined by the category 
argument) define the row. "Samples with hits" are how many samples exceeded the 
hit_threshold for the specified category at the specified site. "Number of 
Samples" indicates how many samples were collected at an individual site 
based on unique date.

The tables contain slightly different results for evaluation of a single site. 
There are three columns (the Site column is dropped), and rather than one row 
per site/category, there is one row per category.
}
\examples{
# This is the example workflow:
path_to_tox <-  system.file("extdata", package="toxEval")
file_name <- "OWC_data_fromSup.xlsx"

full_path <- file.path(path_to_tox, file_name)

tox_list <- create_toxEval(full_path)

ACC <- get_ACC(tox_list$chem_info$CAS)
ACC <- remove_flags(ACC)

cleaned_ep <- clean_endPoint_info(end_point_info)
filtered_ep <- filter_groups(cleaned_ep)
chemical_summary <- get_chemical_summary(tox_list, ACC, filtered_ep)

stats_group <- hits_summary(chemical_summary, "Biological")

hits_summary_DT(chemical_summary, category = "Biological")
hits_summary_DT(chemical_summary, category = "Chemical Class")
hits_summary_DT(chemical_summary, category = "Chemical")

}
