% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_census_and_acs.R
\name{search_tablecontents}
\alias{search_tablecontents}
\title{Search Table Contents}
\usage{
search_tablecontents(survey, years = NULL, keywords = NULL, view = TRUE)
}
\arguments{
\item{survey}{survey type, including "dec" (or "decennial"), "acs1" or "acs5".}

\item{years}{year or ending year of the survey, can be a single year such as
2010 or a vector like 2014:2016.}

\item{keywords}{keyword to search in code or description, in the form like
"abc def dsdfsa". Rows with all words are returned.}

\item{view}{display the search result with View if TRUE}
}
\value{
A data.table
}
\description{
Search in lookup datasets of each survey to find references of
table_contents argument in function \code{\link{read_decennial}},
\code{\link{read_acs1year}}, and \code{\link{read_acs5year}}.
}
\examples{
# Change view = TRUE (default) to View the returned data.
# search by what you want
aaa <- search_tablecontents("dec", 2000, "federal prison", view = FALSE)

# search by table reference
bbb <- search_tablecontents("acs1", 2010:2015, "B02003", view = FALSE)

\dontrun{
  # view all decennial census table contents
  search_tablecontents("dec")

  # view all ACS 5 year table contents
  search_tablecontents("acs5")
}

}
