% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-wavernn.R
\name{model_wavernn}
\alias{model_wavernn}
\title{WaveRNN}
\usage{
model_wavernn(
  upsample_scales,
  n_classes,
  hop_length,
  n_res_block = 10,
  n_rnn = 512,
  n_fc = 512,
  kernel_size = 5,
  n_freq = 128,
  n_hidden = 128,
  n_output = 128
)
}
\arguments{
\item{upsample_scales}{the list of upsample scales.}

\item{n_classes}{the number of output classes.}

\item{hop_length}{the number of samples between the starts of consecutive frames.}

\item{n_res_block}{the number of ResBlock in stack.  (Default: \code{10})}

\item{n_rnn}{the dimension of RNN layer.  (Default: \code{512})}

\item{n_fc}{the dimension of fully connected layer.  (Default: \code{512})}

\item{kernel_size}{the number of kernel size in the first Conv1d layer.  (Default: \code{5})}

\item{n_freq}{the number of bins in a spectrogram.  (Default: \code{128})}

\item{n_hidden}{the number of hidden dimensions of resblock.  (Default: \code{128})}

\item{n_output}{the number of output dimensions of melresnet.  (Default: \code{128})}
}
\value{
Tensor shape:  (n_batch, 1, (n_time - kernel_size + 1) * hop_length, n_classes)
}
\description{
WaveRNN model based on the implementation from \href{https://github.com/fatchord/WaveRNN}{fatchord}.
The original implementation was introduced in \href{https://arxiv.org/pdf/1802.08435.pdf}{"Efficient Neural Audio Synthesis"}.
#' Pass the input through the WaveRNN model.
}
\details{
forward param:

waveform the input waveform to the WaveRNN layer  (n_batch, 1, (n_time - kernel_size + 1) * hop_length)

specgram the input spectrogram to the WaveRNN layer  (n_batch, 1, n_freq, n_time)

The input channels of waveform and spectrogram have to be 1. The product of
\code{upsample_scales} must equal \code{hop_length}.
}
\examples{
if(torch::torch_is_installed()) {
wavernn <- model_wavernn(upsample_scales=c(2,2,3), n_classes=5, hop_length=12)

waveform <- torch::torch_rand(3,1,(10 - 5 + 1)*12)
spectrogram <- torch::torch_rand(3,1,128,10)
# waveform shape:  (n_batch, n_channel, (n_time - kernel_size + 1) * hop_length)
output <- wavernn(waveform, spectrogram)
}
}
