% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-rnn.R
\name{nn_gru}
\alias{nn_gru}
\title{Applies a multi-layer gated recurrent unit (GRU) RNN to an input sequence.}
\usage{
nn_gru(
  input_size,
  hidden_size,
  num_layers = 1,
  bias = TRUE,
  batch_first = FALSE,
  dropout = 0,
  bidirectional = FALSE,
  ...
)
}
\arguments{
\item{input_size}{The number of expected features in the input \code{x}}

\item{hidden_size}{The number of features in the hidden state \code{h}}

\item{num_layers}{Number of recurrent layers. E.g., setting \code{num_layers=2}
would mean stacking two GRUs together to form a \verb{stacked GRU},
with the second GRU taking in outputs of the first GRU and
computing the final results. Default: 1}

\item{bias}{If \code{FALSE}, then the layer does not use bias weights \code{b_ih} and \code{b_hh}.
Default: \code{TRUE}}

\item{batch_first}{If \code{TRUE}, then the input and output tensors are provided
as (batch, seq, feature). Default: \code{FALSE}}

\item{dropout}{If non-zero, introduces a \code{Dropout} layer on the outputs of each
GRU layer except the last layer, with dropout probability equal to
\code{dropout}. Default: 0}

\item{bidirectional}{If \code{TRUE}, becomes a bidirectional GRU. Default: \code{FALSE}}

\item{...}{currently unused.}
}
\description{
For each element in the input sequence, each layer computes the following
function:
}
\details{
\deqn{
\begin{array}{ll}
r_t = \sigma(W_{ir} x_t + b_{ir} + W_{hr} h_{(t-1)} + b_{hr}) \\
z_t = \sigma(W_{iz} x_t + b_{iz} + W_{hz} h_{(t-1)} + b_{hz}) \\
n_t = \tanh(W_{in} x_t + b_{in} + r_t (W_{hn} h_{(t-1)}+ b_{hn})) \\
h_t = (1 - z_t) n_t + z_t h_{(t-1)}
\end{array}
}

where \eqn{h_t} is the hidden state at time \code{t}, \eqn{x_t} is the input
at time \code{t}, \eqn{h_{(t-1)}} is the hidden state of the previous layer
at time \code{t-1} or the initial hidden state at time \code{0}, and \eqn{r_t},
\eqn{z_t}, \eqn{n_t} are the reset, update, and new gates, respectively.
\eqn{\sigma} is the sigmoid function.
}
\note{
All the weights and biases are initialized from \eqn{\mathcal{U}(-\sqrt{k}, \sqrt{k})}
where \eqn{k = \frac{1}{\mbox{hidden\_size}}}
}
\section{Inputs}{


Inputs: input, h_0
\itemize{
\item \strong{input} of shape \verb{(seq_len, batch, input_size)}: tensor containing the features
of the input sequence. The input can also be a packed variable length
sequence. See \code{\link[=nn_utils_rnn_pack_padded_sequence]{nn_utils_rnn_pack_padded_sequence()}}
for details.
\item \strong{h_0} of shape \verb{(num_layers * num_directions, batch, hidden_size)}: tensor
containing the initial hidden state for each element in the batch.
Defaults to zero if not provided.
}
}

\section{Outputs}{


Outputs: output, h_n
\itemize{
\item \strong{output} of shape \verb{(seq_len, batch, num_directions * hidden_size)}: tensor
containing the output features h_t from the last layer of the GRU,
for each t. If a \code{PackedSequence} has been
given as the input, the output will also be a packed sequence.
For the unpacked case, the directions can be separated
using \code{output$view(c(seq_len, batch, num_directions, hidden_size))},
with forward and backward being direction \code{0} and \code{1} respectively.
Similarly, the directions can be separated in the packed case.
\item \strong{h_n} of shape \verb{(num_layers * num_directions, batch, hidden_size)}: tensor
containing the hidden state for \code{t = seq_len}
Like \emph{output}, the layers can be separated using
\code{h_n$view(num_layers, num_directions, batch, hidden_size)}.
}
}

\section{Attributes}{

\itemize{
\item \code{weight_ih_l[k]} : the learnable input-hidden weights of the \eqn{\mbox{k}^{th}} layer
(W_ir|W_iz|W_in), of shape \verb{(3*hidden_size x input_size)}
\item \code{weight_hh_l[k]} : the learnable hidden-hidden weights of the \eqn{\mbox{k}^{th}} layer
(W_hr|W_hz|W_hn), of shape \verb{(3*hidden_size x hidden_size)}
\item \code{bias_ih_l[k]} : the learnable input-hidden bias of the \eqn{\mbox{k}^{th}} layer
(b_ir|b_iz|b_in), of shape \code{(3*hidden_size)}
\item \code{bias_hh_l[k]} : the learnable hidden-hidden bias of the \eqn{\mbox{k}^{th}} layer
(b_hr|b_hz|b_hn), of shape \code{(3*hidden_size)}
}
}

\examples{
if (torch_is_installed()) {

rnn <- nn_gru(10, 20, 2)
input <- torch_randn(5, 3, 10)
h0 <- torch_randn(2, 3, 20)
output <- rnn(input, h0)
}
}
