% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_logit}
\alias{torch_logit}
\title{Logit}
\usage{
torch_logit(self, eps = NULL)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{eps}{(float, optional) the epsilon for input clamp bound. Default: \code{None}}
}
\description{
Logit
}
\section{logit(input, eps=None, *, out=None) -> Tensor }{


Returns a new tensor with the logit of the elements of \code{input}.
\code{input} is clamped to \verb{[eps, 1 - eps]} when eps is not None.
When eps is None and \code{input} < 0 or \code{input} > 1, the function will yields NaN.

\deqn{
    y_{i} = \ln(\frac{z_{i}}{1 - z_{i}}) \\
    z_{i} = \begin{array}{ll}
        x_{i} & \mbox{if eps is None} \\
        \mbox{eps} & \mbox{if } x_{i} < \mbox{eps} \\
        x_{i} & \mbox{if } \mbox{eps} \leq x_{i} \leq 1 - \mbox{eps} \\
        1 - \mbox{eps} & \mbox{if } x_{i} > 1 - \mbox{eps}
    \end{array}
}
}

\examples{
if (torch_is_installed()) {

a <- torch_rand(5)
a
torch_logit(a, eps=1e-6)
}
}
