% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_nanquantile}
\alias{torch_nanquantile}
\title{Nanquantile}
\usage{
torch_nanquantile(self, q, dim = NULL, keepdim = FALSE, interpolation)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{q}{(float or Tensor) a scalar or 1D tensor of quantile values in the range \verb{[0, 1]}}

\item{dim}{(int) the dimension to reduce.}

\item{keepdim}{(bool) whether the output tensor has \code{dim} retained or not.}

\item{interpolation}{The interpolation method.}
}
\description{
Nanquantile
}
\section{nanquantile(input, q, dim=None, keepdim=FALSE, *, out=None) -> Tensor }{


This is a variant of \code{\link[=torch_quantile]{torch_quantile()}} that "ignores" \code{NaN} values,
computing the quantiles \code{q} as if \code{NaN} values in \code{input} did
not exist. If all values in a reduced row are \code{NaN} then the quantiles for
that reduction will be \code{NaN}. See the documentation for \code{\link[=torch_quantile]{torch_quantile()}}.
}

\examples{
if (torch_is_installed()) {

t <- torch_tensor(c(NaN, 1, 2))
t$quantile(0.5)
t$nanquantile(0.5)
t <- torch_tensor(rbind(c(NaN, NaN), c(1, 2)))
t
t$nanquantile(0.5, dim=1)
t$nanquantile(0.5, dim=2)
torch_nanquantile(t, 0.5, dim = 1)
torch_nanquantile(t, 0.5, dim = 2)
}
}
