% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_where}
\alias{torch_where}
\title{Where}
\usage{
torch_where(condition, self, other)
}
\arguments{
\item{condition}{(BoolTensor) When TRUE (nonzero), yield x, otherwise yield y}

\item{self}{(Tensor) values selected at indices where \code{condition} is \code{TRUE}}

\item{other}{(Tensor) values selected at indices where \code{condition} is \code{FALSE}}
}
\description{
Where
}
\note{
\preformatted{The tensors `condition`, `x`, `y` must be broadcastable .
}

See also \code{\link[=torch_nonzero]{torch_nonzero()}}.
}
\section{where(condition, x, y) -> Tensor }{


Return a tensor of elements selected from either \code{x} or \code{y}, depending on \code{condition}.

The operation is defined as:

\deqn{
    \mbox{out}_i = \left\{ \begin{array}{ll}
        \mbox{x}_i & \mbox{if } \mbox{condition}_i \\
        \mbox{y}_i & \mbox{otherwise} \\
    \end{array}
    \right.
}
}

\section{where(condition) -> tuple of LongTensor }{


\code{torch_where(condition)} is identical to
\code{torch_nonzero(condition, as_tuple=TRUE)}.
}

\examples{
if (torch_is_installed()) {

\dontrun{
x = torch_randn(c(3, 2))
y = torch_ones(c(3, 2))
x
torch_where(x > 0, x, y)
}



}
}
