% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-pooling.R
\name{nn_avg_pool1d}
\alias{nn_avg_pool1d}
\title{Applies a 1D average pooling over an input signal composed of several
input planes.}
\usage{
nn_avg_pool1d(
  kernel_size,
  stride = NULL,
  padding = 0,
  ceil_mode = FALSE,
  count_include_pad = TRUE
)
}
\arguments{
\item{kernel_size}{the size of the window}

\item{stride}{the stride of the window. Default value is \code{kernel_size}}

\item{padding}{implicit zero padding to be added on both sides}

\item{ceil_mode}{when TRUE, will use \code{ceil} instead of \code{floor} to compute the output shape}

\item{count_include_pad}{when TRUE, will include the zero-padding in the averaging calculation}
}
\description{
In the simplest case, the output value of the layer with input size \eqn{(N, C, L)},
output \eqn{(N, C, L_{out})} and \code{kernel_size} \eqn{k}
can be precisely described as:

\deqn{
  \mbox{out}(N_i, C_j, l) = \frac{1}{k} \sum_{m=0}^{k-1}
\mbox{input}(N_i, C_j, \mbox{stride} \times l + m)
}
}
\details{
If \code{padding} is non-zero, then the input is implicitly zero-padded on both sides
for \code{padding} number of points.

The parameters \code{kernel_size}, \code{stride}, \code{padding} can each be
an \code{int} or a one-element tuple.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, C, L_{in})}
\item Output: \eqn{(N, C, L_{out})}, where
}

\deqn{
  L_{out} = \left\lfloor \frac{L_{in} +
      2 \times \mbox{padding} - \mbox{kernel\_size}}{\mbox{stride}} + 1\right\rfloor
}
}

\examples{
if (torch_is_installed()) {
  
# pool with window of size=3, stride=2
m <- nn_avg_pool1d(3, stride=2)
m(torch_randn(1, 1, 8))

}
}
