% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creation-ops.R, R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_zeros}
\alias{torch_zeros}
\title{Zeros}
\usage{
torch_zeros(
  ...,
  names = NULL,
  dtype = NULL,
  layout = NULL,
  device = NULL,
  requires_grad = FALSE
)
}
\arguments{
\item{...}{a sequence of integers defining the shape of the output tensor.        Can be a variable number of arguments or a collection like a list or tuple.}

\item{names}{optional dimension names}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of returned tensor.        Default: if \code{NULL}, uses a global default (see \code{torch_set_default_tensor_type}).}

\item{layout}{(\code{torch.layout}, optional) the desired layout of returned Tensor.        Default: \code{torch_strided}.}

\item{device}{(\code{torch.device}, optional) the desired device of returned tensor.        Default: if \code{NULL}, uses the current device for the default tensor type        (see \code{torch_set_default_tensor_type}). \code{device} will be the CPU        for CPU tensor types and the current CUDA device for CUDA tensor types.}

\item{requires_grad}{(bool, optional) If autograd should record operations on the        returned tensor. Default: \code{FALSE}.}
}
\description{
Zeros
}
\section{zeros(*size, out=NULL, dtype=NULL, layout=torch.strided, device=NULL, requires_grad=False) -> Tensor }{


Returns a tensor filled with the scalar value \code{0}, with the shape defined
by the variable argument \code{size}.
}

\examples{
if (torch_is_installed()) {

torch_zeros(c(2, 3))
torch_zeros(c(5))
}
}
