% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_tensorsolve}
\alias{linalg_tensorsolve}
\title{Computes the solution \code{X} to the system \code{torch_tensordot(A, X) = B}.}
\usage{
linalg_tensorsolve(A, B, dims = NULL)
}
\arguments{
\item{A}{(Tensor): tensor to solve for.}

\item{B}{(Tensor): the solution}

\item{dims}{(\code{Tuple[int]}, optional): dimensions of \code{A} to be moved.
If \code{NULL}, no dimensions are moved. Default: \code{NULL}.}
}
\description{
If \code{m} is the product of the first \code{B}\ \code{.ndim}  dimensions of \code{A} and
\code{n} is the product of the rest of the dimensions, this function expects \code{m} and \code{n} to be equal.
The returned tensor \code{x} satisfies
\code{tensordot(A, x, dims=x$ndim) == B}.
}
\details{
If \code{dims} is specified, \code{A} will be reshaped as
\code{A = movedim(A, dims, seq(len(dims) - A$ndim + 1, 0))}

Supports inputs of float, double, cfloat and cdouble dtypes.
}
\examples{
if (torch_is_installed()) {
A <- torch_eye(2 * 3 * 4)$reshape(c(2 * 3, 4, 2, 3, 4))
B <- torch_randn(2 * 3, 4)
X <- linalg_tensorsolve(A, B)
X$shape
torch_allclose(torch_tensordot(A, X, dims = X$ndim), B)

A <- torch_randn(6, 4, 4, 3, 2)
B <- torch_randn(4, 3, 2)
X <- linalg_tensorsolve(A, B, dims = c(1, 3))
A <- A$permute(c(2, 4, 5, 1, 3))
torch_allclose(torch_tensordot(A, X, dims = X$ndim), B, atol = 1e-6)
}
}
\seealso{
\itemize{
\item \code{\link[=linalg_tensorinv]{linalg_tensorinv()}} computes the multiplicative inverse of
\code{\link[=torch_tensordot]{torch_tensordot()}}.
}

Other linalg: 
\code{\link{linalg_cholesky}()},
\code{\link{linalg_cholesky_ex}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvals}()},
\code{\link{linalg_eigvalsh}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv}()},
\code{\link{linalg_inv_ex}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_power}()},
\code{\link{linalg_matrix_rank}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_norm}()},
\code{\link{linalg_pinv}()},
\code{\link{linalg_qr}()},
\code{\link{linalg_slogdet}()},
\code{\link{linalg_solve}()},
\code{\link{linalg_solve_triangular}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_tensorinv}()},
\code{\link{linalg_vector_norm}()}
}
\concept{linalg}
