% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_matmul}
\alias{torch_matmul}
\title{Matmul}
\usage{
torch_matmul(self, other)
}
\arguments{
\item{self}{(Tensor) the first tensor to be multiplied}

\item{other}{(Tensor) the second tensor to be multiplied}
}
\description{
Matmul
}
\note{
\preformatted{The 1-dimensional dot product version of this function does not support an `out` parameter.
}
}
\section{matmul(input, other, out=NULL) -> Tensor }{


Matrix product of two tensors.

The behavior depends on the dimensionality of the tensors as follows:
\itemize{
\item If both tensors are 1-dimensional, the dot product (scalar) is returned.
\item If both arguments are 2-dimensional, the matrix-matrix product is returned.
\item If the first argument is 1-dimensional and the second argument is 2-dimensional,
a 1 is prepended to its dimension for the purpose of the matrix multiply.
After the matrix multiply, the prepended dimension is removed.
\item If the first argument is 2-dimensional and the second argument is 1-dimensional,
the matrix-vector product is returned.
\item If both arguments are at least 1-dimensional and at least one argument is
N-dimensional (where N > 2), then a batched matrix multiply is returned.  If the first
argument is 1-dimensional, a 1 is prepended to its dimension for the purpose of the
batched matrix multiply and removed after.  If the second argument is 1-dimensional, a
1 is appended to its dimension for the purpose of the batched matrix multiple and removed after.
The non-matrix (i.e. batch) dimensions are broadcasted  (and thus
must be broadcastable).  For example, if \code{input} is a
\eqn{(j \times 1 \times n \times m)} tensor and \code{other} is a \eqn{(k \times m \times p)}
tensor, \code{out} will be an \eqn{(j \times k \times n \times p)} tensor.
}
}

\examples{
if (torch_is_installed()) {

# vector x vector
tensor1 = torch_randn(c(3))
tensor2 = torch_randn(c(3))
torch_matmul(tensor1, tensor2)
# matrix x vector
tensor1 = torch_randn(c(3, 4))
tensor2 = torch_randn(c(4))
torch_matmul(tensor1, tensor2)
# batched matrix x broadcasted vector
tensor1 = torch_randn(c(10, 3, 4))
tensor2 = torch_randn(c(4))
torch_matmul(tensor1, tensor2)
# batched matrix x batched matrix
tensor1 = torch_randn(c(10, 3, 4))
tensor2 = torch_randn(c(10, 4, 5))
torch_matmul(tensor1, tensor2)
# batched matrix x broadcasted matrix
tensor1 = torch_randn(c(10, 3, 4))
tensor2 = torch_randn(c(4, 5))
torch_matmul(tensor1, tensor2)
}
}
