% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_renorm}
\alias{torch_renorm}
\title{Renorm}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{p}{(float) the power for the norm computation}

\item{dim}{(int) the dimension to slice over to get the sub-tensors}

\item{maxnorm}{(float) the maximum norm to keep each sub-tensor under}

\item{out}{(Tensor, optional) the output tensor.}
}
\description{
Renorm
}
\note{
If the norm of a row is lower than \code{maxnorm}, the row is unchanged
}
\section{renorm(input, p, dim, maxnorm, out=None) -> Tensor }{


Returns a tensor where each sub-tensor of \code{input} along dimension
\code{dim} is normalized such that the \code{p}-norm of the sub-tensor is lower
than the value \code{maxnorm}
}

\examples{
if (torch_is_installed()) {
x = torch_ones(c(3, 3))
x[2,]$fill_(2)
x[3,]$fill_(3)
x
torch_renorm(x, 1, 1, 5)
}
}
