% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-pooling.R
\name{nn_max_pool1d}
\alias{nn_max_pool1d}
\title{MaxPool1D module}
\usage{
nn_max_pool1d(
  kernel_size,
  stride = NULL,
  padding = 0,
  dilation = 1,
  return_indices = FALSE,
  ceil_mode = FALSE
)
}
\arguments{
\item{kernel_size}{the size of the window to take a max over}

\item{stride}{the stride of the window. Default value is \code{kernel_size}}

\item{padding}{implicit zero padding to be added on both sides}

\item{dilation}{a parameter that controls the stride of elements in the window}

\item{return_indices}{if \code{TRUE}, will return the max indices along with the outputs.
Useful for  \code{nn_max_unpool1d()} later.}

\item{ceil_mode}{when \code{TRUE}, will use \code{ceil} instead of \code{floor} to compute the output shape}
}
\description{
Applies a 1D max pooling over an input signal composed of several input
planes.
}
\details{
In the simplest case, the output value of the layer with input size \eqn{(N, C, L)}
and output \eqn{(N, C, L_{out})} can be precisely described as:

\deqn{
  out(N_i, C_j, k) = \max_{m=0, \ldots, \mbox{kernel\_size} - 1}
input(N_i, C_j, stride \times k + m)
}

If \code{padding} is non-zero, then the input is implicitly zero-padded on both sides
for \code{padding} number of points. \code{dilation} controls the spacing between the kernel points.
It is harder to describe, but this \href{https://github.com/vdumoulin/conv_arithmetic/blob/master/README.md}{link}
has a nice visualization of what \code{dilation} does.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, C, L_{in})}
\item Output: \eqn{(N, C, L_{out})}, where
}

\deqn{
  L_{out} = \left\lfloor \frac{L_{in} + 2 \times \mbox{padding} - \mbox{dilation}
    \times (\mbox{kernel\_size} - 1) - 1}{\mbox{stride}} + 1\right\rfloor
}
}

\examples{
if (torch_is_installed()) {
# pool of size=3, stride=2
m <- nn_max_pool1d(3, stride=2)
input <- torch_randn(20, 16, 50)
output <- m(input)

}
}
