% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_csv.R
\name{list_csv}
\alias{list_csv}
\alias{list_tsv}
\alias{list_rds}
\alias{list_rdata}
\title{Import multiple common files from a directory into a list.}
\usage{
list_csv(path = ".", regexp = "[.]csv$", ignore.case = TRUE,
  invert = FALSE, ...)

list_tsv(path = ".", regexp = "[.]tsv$", ignore.case = TRUE,
  invert = FALSE, ...)

list_rds(path = ".", regexp = "[.]rds$", ignore.case = TRUE,
  invert = FALSE)

list_rdata(path = ".", regexp = "[.]rdata$|[.]rda$",
  ignore.case = TRUE, invert = FALSE)
}
\arguments{
\item{path}{A character vector of one path. Defaults to the working
directory.}

\item{regexp}{A regular expression (e.g. \code{[.]csv$}) passed on to \code{\link[=grep]{grep()}} to filter paths.}

\item{ignore.case}{if \code{FALSE}, the pattern matching is \emph{case
      sensitive} and if \code{TRUE}, case is ignored during matching.}

\item{invert}{If \code{TRUE} return files which do \emph{not} match}

\item{...}{Arguments passed to \code{readr::read_csv()} or \code{readr::read_tsv()}.}
}
\value{
A list.
}
\description{
These functions wrap common use-cases of \code{\link[=list_any]{list_any()}}.
}
\examples{
(rds <- tor_example("rds"))
dir(rds)

list_rds(rds)

(tsv <- tor_example("tsv"))
dir(tsv)

list_tsv(tsv)

(mixed <- tor_example("mixed"))
dir(mixed)

list_rdata(mixed)

list_csv(mixed)

list_rdata(mixed, regexp = "[.]RData", ignore.case = FALSE)
}
\seealso{
Other functions to import files into a list: \code{\link{list_any}}

Other functions to import files of common formats: \code{\link{load_csv}}
}
\concept{functions to import files into a list}
\concept{functions to import files of common formats}
