% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R
\name{plot.profile_likelihood}
\alias{plot.profile_likelihood}
\title{Plot Method for Profile Likelihood Objects}
\usage{
\method{plot}{profile_likelihood}(x, LL_max, width = 3.5, height = 3.5, save_plot = FALSE, output_dir, ...)
}
\arguments{
\item{x}{A profile_likelihood object}

\item{LL_max}{Numeric maximum log-likelihood value}

\item{width}{Numeric width of output plot in inches (default: 3.5)}

\item{height}{Numeric height of output plot in inches (default: 3.5)}

\item{save_plot}{Logical. Whether to save plot to file. Default: FALSE}

\item{output_dir}{Character. Directory for output files. Required if \code{save_plot} is TRUE.}

\item{...}{Additional arguments passed to plot}
}
\value{
A ggplot object
}
\description{
Creates a visualization of profile likelihood for a parameter showing maximum
likelihood estimates and confidence intervals. Supports mathematical notation
for parameter names and configurable output settings.

Confidence interval is found using the likelihood ratio test:
\eqn{LR(\theta_{ij}) = -2[log L_{max}(\theta_{ij}) - log L_{max}(\hat{\theta})]}
where \eqn{\hat{\theta}} is the maximum likelihood estimate for all parameters.
The 95\% confidence interval is:
\eqn{\{\theta_{ij} : LR(\theta_{ij}) \leq \chi^2_{1,0.05} = 3.84\}}
}
\examples{
# These examples take more than 5 seconds to run, so they are not run by default. 
# Use parallel processing (the default) to speed up.
\donttest{
# Create a sample data frame of MCMC samples
samples <- data.frame(
  log_N = log(runif(50, 2, 10)),
  log_k0 = log(runif(50, 1, 5)),
  log_cooling_rate = log(runif(50, 0.01, 0.1)),
  log_c_repulsion = log(runif(50, 0.1, 1)),
  NLL = runif(50, 20, 100)
)

# Calculate profile likelihood
pl_result <- profile_likelihood("log_N", samples, grid_size = 10)

# Plot with maximum likelihood from samples
LL_max <- max(-samples$NLL)
# The plot function requires the ggplot2 package
if (requireNamespace("ggplot2", quietly = TRUE)) {
  plot(pl_result, LL_max, width = 4, height = 3)
}
}
}
