% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_from_corpus.R
\name{dist_from_corpus}
\alias{dist_from_corpus}
\title{Calculate the distance of each topic from the overall corpus token distribution}
\usage{
dist_from_corpus(topic_model, dtm_data)
}
\arguments{
\item{topic_model}{a fitted topic model object from one of the following:
\code{\link[topicmodels]{tm-class}}}

\item{dtm_data}{a document-term matrix of token counts coercible to \code{simple_triplet_matrix}}
}
\value{
A vector of distances with length equal to the number of topics in the fitted model
}
\description{
The Hellinger distance between the token probabilities or betas for each topic and
the overall probability for the word in the corpus is calculated.
}
\examples{

# Using the example from the LDA function
library(topicmodels)
data("AssociatedPress", package = "topicmodels")
lda <- LDA(AssociatedPress[1:20,], control = list(alpha = 0.1), k = 2)
dist_from_corpus(lda, AssociatedPress[1:20,])
}
\references{
{
  Jordan Boyd-Graber, David Mimno, and David Newman, 2014.
  \emph{Care and Feeding of Topic Models: Problems, Diagnostics, and Improvements.}
  CRC Handbooks ofModern Statistical Methods. CRC Press, Boca Raton, Florida.
}
}
