% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag_tokens.r
\name{highlight_tokens}
\alias{highlight_tokens}
\title{Highlight tokens}
\usage{
highlight_tokens(tokens, value, col = "yellow", span_adjacent = F)
}
\arguments{
\item{tokens}{A character vector of tokens}

\item{value}{Either a logical vector or a numeric vector with values between 0 and 1.
If a logical vector is used, then tokens with TRUE will be highlighted (with the color specified in pos_col).
If a numeric vector is used, the value determines the alpha (transparency), with 0 being fully transparent
and 1 being fully colored.}

\item{col}{The color used to highlight}

\item{span_adjacent}{If TRUE, include adjacent tokens with identical attributes within the same tag}
}
\value{
a character vector of color-tagged tokens
}
\description{
This is a convenience wrapper for tag_tokens() that can be used if tokens only need to be colored.
}
\examples{
highlight_tokens(c('token_1','token_2','token_3'),
                 value = c(FALSE,FALSE,TRUE))

highlight_tokens(c('token_1','token_2','token_3'),
                 value = c(0,0.3,0.6))
}
