% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeKmeans.R
\name{computeClusterSample}
\alias{computeClusterSample}
\title{Random sample of clustered data}
\usage{
computeClusterSample(channel, km, sampleFraction, sampleSize, scaled = FALSE,
  includeId = TRUE, test = FALSE)
}
\arguments{
\item{channel}{connection object as returned by \code{\link{odbcConnect}}.}

\item{km}{an object of class \code{"toakmeans"} obtained with \code{computeKmeans}.}

\item{sampleFraction}{vector with one or more sample fractions to use in the sampling of data.
Multiple fractions define sampling for each cluster in kmeans \code{km} object where
vector length must be equal to the number of clusters.}

\item{sampleSize}{vector with sample size (applies only when \code{sampleFraction} is missing).
Multiple sizes define sampling for each cluster in kmeans \code{km} object where
vector length must be equal to the number of clusters.}

\item{scaled}{logical: indicates if original (default) or scaled data returned.}

\item{includeId}{logical indicates if sample should include key attribute identifying
each data point.}

\item{test}{logical: if TRUE show what would be done, only (similar to parameter \code{test} in \pkg{RODBC} 
functions: \link{sqlQuery} and \link{sqlSave}).}
}
\value{
\code{computeClusterSample} returns an object of class \code{"toakmeans"} (compatible with class \code{"kmeans"}).
}
\description{
Random sample of clustered data
}
\examples{
if(interactive()){
# initialize connection to Lahman baseball database in Aster 
conn = odbcDriverConnect(connection="driver={Aster ODBC Driver};
                         server=<dbhost>;port=2406;database=<dbname>;uid=<user>;pwd=<pw>")
                         
km = computeKmeans(conn, "batting", centers=5, iterMax = 25,
                   aggregates = c("COUNT(*) cnt", "AVG(g) avg_g", "AVG(r) avg_r", "AVG(h) avg_h"),
                   id="playerid || '-' || stint || '-' || teamid || '-' || yearid", 
                   include=c('g','r','h'), scaledTableName='kmeans_test_scaled', 
                   centroidTableName='kmeans_test_centroids',
                   where="yearid > 2000")
km = computeClusterSample(conn, km, 0.01)
km
createClusterPairsPlot(km, title="Batters Clustered by G, H, R", ticks=FALSE)

# per cluster sample fractions
km = computeClusterSample(conn, km, c(0.01, 0.02, 0.03, 0.02, 0.01))
}
}
\seealso{
\code{\link{computeKmeans}}
}

