% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeGraph.R
\name{computeEgoGraph}
\alias{computeEgoGraph}
\title{Find the vertices not farther than a given limit from another fixed vertex, 
and create egographs (subgraphs) with the given order parameter.}
\usage{
computeEgoGraph(channel, graph, ego, order = 1, mode = "all",
  createDistanceAttr = TRUE, distanceAttrname = "ego.distance",
  vertexWhere = graph$vertexWhere, edgeWhere = graph$edgeWhere,
  allTables = NULL, test = FALSE)
}
\arguments{
\item{channel}{connection object as returned by \code{\link{odbcConnect}}}

\item{graph}{an object of class \code{'toagraph'} referencing graph 
tables in Aster database.}

\item{ego}{list of vertices for which the calculation of corresponding ego graphs is performed.}

\item{order}{integer giving the order of the ego graph neighborhood.}

\item{mode}{character constant, it specifies how to use the direction of the edges if a directed graph is analyzed. 
For \code{'out'} only the outgoing edges are followed, so all vertices reachable from the source vertex in at 
most order steps are counted. For \code{'in'} all vertices from which the source vertex is reachable in at most 
\code{order} steps are counted. \code{'all'} ignores the direction of the edges. This argument is ignored 
for undirected graphs.}

\item{createDistanceAttr}{logical: indicates if vertices should receive attribute with the distance
to ego graph centeral vertex.}

\item{distanceAttrname}{name of the vertex distance attribute.}

\item{vertexWhere}{SQL WHERE clause limiting data from the vertex table. This value when not null
overrides corresponding value \code{vertexWhere} from \code{graph} (use SQL as if in WHERE clause but 
omit keyword WHERE).}

\item{edgeWhere}{SQL WHERE clause limiting data from the edge table. This value when not null
overrides corresponding value \code{edgeWhere} from \code{graph} (use SQL as if in WHERE clause but 
omit keyword WHERE).}

\item{allTables}{pre-built information about existing tables.}

\item{test}{logical: if TRUE show what would be done, only (similar to parameter \code{test} in \pkg{RODBC} 
functions: \link{sqlQuery} and \link{sqlSave}).}
}
\description{
Find the vertices not farther than a given limit from another fixed vertex, 
and create egographs (subgraphs) with the given order parameter.
}
\examples{
if(interactive()) {
library(GGally)

policeGraphDi = toaGraph(vertices = "dallaspolice_officer_vertices", 
                         edges = "dallaspolice_officer_edges_di", 
                         directed = TRUE,
                         key = "officer", source = "officer1", target = "officer2", 
                         vertexAttrnames = c("offense_count"),
                         edgeAttrnames = c("weight"))
               
# initialize connection to Lahman baseball database in Aster 
conn = odbcDriverConnect(connection="driver={Aster ODBC Driver};
                         server=<dbhost>;port=2406;database=<dbname>;uid=<user>;pwd=<pw>")
                         
setVertexColor <- function(graph, vertex, color="red", default="grey") {
  graph \%v\% "color" = 
  ifelse(get.vertex.attribute(graph, "vertex.names") == as.character(vertex),
         color, default)
  
  return(graph)
}

topPagerankPolice = computeGraphMetric(conn, policeGraphDi, type='pagerank', top=3)
egoCenters = as.list(as.character(topPagerankPolice$key))

egoGraphsTopPagerank = computeEgoGraph(conn, policeGraphDi, order = 1, ego = egoCenters)

egoGraph = setVertexColor(egoGraphsTopPagerank[[1]], egoCenters[[1]])
ggnet2(egoGraph, node.label="vertex.names",  node.size="offense_count",
       legend.position="none", color="color")

egoGraph = setVertexColor(egoGraphsTopPagerank[[2]], egoCenters[[2]])
ggnet2(egoGraph, node.label="vertex.names",  node.size="offense_count",
       legend.position="none", color="color")

egoGraph = setVertexColor(egoGraphsTopPagerank[[3]], egoCenters[[3]])
ggnet2(egoGraph, node.label="vertex.names",  node.size="offense_count",
       legend.position="none", color="color")
}
}

