% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tna_communities}
\alias{plot.tna_communities}
\title{Plot Communities}
\usage{
\method{plot}{tna_communities}(x, cluster = 1L, colors, method = "spinglass", ...)
}
\arguments{
\item{x}{A \code{communities} object generated by the \code{find_communities} method.
Each community detection method maps nodes or points in to a specific
communities.}

\item{cluster}{An \code{integer} index of the cluster for which to produce the
plot. Defaults to the first cluster.}

\item{colors}{A \code{character} vector of color values used for visualizing
community assignments.}

\item{method}{A \code{character} string naming a community detection method to
use for coloring the plot. This can be one of the following:}

\item{...}{Additional arguments passed to \link[qgraph:qgraph]{qgraph::qgraph}.
\itemize{
\item \code{"walktrap"}: A community detection method using short random walks.
\item \code{"fast_greedy"}: A method based on modularity optimization.
\item \code{"label_prop"}: A method that uses label propagation.
\item \code{"infomap"}: A method that uses information flow to detect communities.
\item \code{"edge_betweenness"}: A method that uses edge betweenness to find
communities.
\item \code{"leading_eigen"}: A method using the leading eigenvector of the
modularity matrix.
\item \code{"spinglass"}: A method based on the spinglass model.
}}
}
\value{
A \code{qgraph} object in which the nodes are colored by community.
}
\description{
This function visualizes the communities detected within a \code{tna} object
based on different community detection algorithms and their corresponding
color mappings.
}
\examples{
model <- tna(group_regulation)
comm <- communities(model)
plot(comm, method = "leading_eigen")

}
\seealso{
Pattern-finding functions
\code{\link{communities}()}
}
\concept{patterns}
