% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.R
\name{modCorPlot}
\alias{modCorPlot}
\title{Plot a correlation heatmap for modules}
\usage{
modCorPlot(
  modules,
  mset = NULL,
  labels = NULL,
  stat = "jaccard",
  upper.cutoff = 0.1,
  ...
)
}
\arguments{
\item{modules}{either a character vector with module IDs from mset, or a list which
contains the module members}

\item{mset}{Which module set to use. Either a character vector ("LI", "DC" or "all", default: LI) or an object of class tmod (see "Custom module definitions" below)}

\item{labels}{Labels for the modules (if NULL, labels will be retrieved from `mset`)}

\item{stat}{Type of statistics to return. 
"number": number of common genes (default);
"jaccard": Jaccard index;
"soerensen": Soerensen-Dice coefficient;
"overlap": Szymkiewicz-Simpson coefficient.}

\item{upper.cutoff}{Specify upper cutoff for the color palette}

\item{...}{Any further parameters are passed to heatmap.2}
}
\description{
Plot a correlation heatmap for modules
}
