% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panelplots.R
\name{pvalEffectPlot}
\alias{pvalEffectPlot}
\title{Create an effect size / p-value plot}
\usage{
pvalEffectPlot(e, p, pval.thr = 0.01, pval.cutoff = 1e-06,
  row.labels = NULL, col.labels = NULL, plot.func = NULL, grid = "at",
  grid.color = "#333333", plot.cex = 1, text.cex = 1,
  col.labels.style = "top", legend.style = "auto")
}
\arguments{
\item{e}{matrix with effect sizes}

\item{p}{matrix with probabilities}

\item{pval.thr}{The p-value must be this or lower in order for a test result to be visualized}

\item{pval.cutoff}{On visual scale, all p-values below pval.cutoff will be replaced by pval.cutoff}

\item{row.labels}{Labels for the modules. This must be a named vector, with module IDs as vector names. If NULL, module titles from
the analyses results will be used.}

\item{col.labels}{Labels for the columns. If NULL, names of the elements
of the list x will be used.}

\item{plot.func}{Optionally, a function to be used to draw the dots. See "Details"}

\item{grid}{Style of a light-grey grid to be plotted; can be "none", "at" and "between"}

\item{grid.color}{Color of the grid to be plotted (default: light grey)}

\item{plot.cex}{a numerical value giving the amount by which the plot
symbols will be maginfied}

\item{text.cex}{a numerical value giving the amount by which the plot
text will be magnified, or a vector containing three cex values for row labels, column labels and legend, respectively}

\item{col.labels.style}{Style of column names: "top" (default), "bottom", "both", "none"}

\item{legend.style}{Style of the legend: "auto" -- automatic; "broad":
pval legend side by side with effect size legend; "tall": effect size
legend above pval legend; "none" -- no legend.}
}
\value{
Invisibly returns a NULL value.
}
\description{
Create a heatmap-like plot showing information about both effect size
and p-values.
}
\details{
pvalEffectPlot shows a heatmap-like plot. Each row corresponds to one
series of tests (e.g. one module), and each column corresponds to the time points or conditions for which
a given analysis was run. Each significant result is shown as
a red dot. Size of the dot corresponds to the effect size (or any
arbitrary value), and intensity of the color corresponds to the log10 of
p-value.

Just like a heatmap corresponds to a single numeric matrix, the pvalue /
effect plot corresponds to two matrices: one with the effect size, and
another one with the p-values. Each cell in the matrix corresponds to the
results of a single statistical test.

For example, a number of genes or transcriptional modules might be tested
for differential expression or enrichment, respectively, in several conditions.

By default, each test outcome is represented by a dot of varying size
and color. Alternatively, a function may be specified with the parameter
'plot.func'. It will be called for each test result to be drawn. The plot.func function must take the following arguments:
\itemize{
\item{row, col}{either row / column number or the id of the row / column to plot; NULL if drawing legend}
\item{x, y}{user coordinates of the result to visualize}
\item{w, h}{width and height of the item to plot}
\item{e}{Enrichment -- a relative value between 0 and 1, where 0 is the minimum and 1 is the maximum enrichment found}
\item{p}{P-value -- an absolute value between 0 and 1}
}
For the purposes of drawing a legend, the function must accept NULL
p-value or a NULL enrichment parameter.
}

