% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/importexport.R
\name{tmodImportMSigDB}
\alias{tmodImportMSigDB}
\title{Import data from MSigDB}
\usage{
tmodImportMSigDB(file = NULL, format = "xml", organism = "Homo sapiens",
  fields = c("STANDARD_NAME", "CATEGORY_CODE", "SUBCATEGORY_CODE"))
}
\arguments{
\item{file}{The name of the file to parse}

\item{format}{Format (either "xml" or "gmt")}

\item{organism}{Select the organism to use. Use "all" for all organisms in the file (only for "xml" format; default: "Homo sapiens")}

\item{fields}{Which fields to import to the MODULES data frame (only for "xml" format)}
}
\description{
Import data from an MSigDB file in either XML or GMT format
}
\details{
This command parses a file from MSigDB. Both XML and the MSigDB-specific
"GMT" format are supported (however, the latter is discouraged, as it
contains less information).
}
\examples{
\dontrun{
## First, download the file "msigdb_v5.0.xml" from http://www.broadinstitute.org/gsea/downloads.jsp
msig <- tmodImportMSigDB( "msigdb_v5.0.xml" )
}
}

