#' Thematic Map Visualization
#'
#' Thematic maps are geographical maps in which spatial data distributions are visualized.
#' This package offers a flexible, layer-based, and easy to use approach to create
#' thematic maps, such as choropleths and bubble maps. It is based on the grammar
#' of graphics, and resembles the syntax of ggplot2.
#'
#' @author Martijn Tennekes \email{mtennekes@@gmail.com}
#' @seealso \href{https://r-tmap.github.io/tmap/index.html}{Main documentation}
#' @concept GIS
#' @concept thematic maps
#' @concept statistical maps
#' @concept choropleth
#' @concept bubble map
#' @references Tennekes, M., 2018, {tmap}: Thematic Maps in {R}, Journal of Statistical Software, 84(6), 1-39, \doi{10.18637/jss.v084.i06}
"_PACKAGE"
