% Generated by roxygen2 (4.0.1): do not edit by hand
\name{tm_text}
\alias{tm_text}
\title{Add text labels}
\usage{
tm_text(text, cex = 1, root = 3, fontcolor = NA, fontface = "plain",
  fontfamily = "sans", case = NA, bg.color = NA, bg.alpha = 100,
  cex.lowerbound = 0.4, print.tiny = FALSE, scale = 1, xmod = 0,
  ymod = 0)
}
\arguments{
\item{text}{name of the variable in the shape object that contains the text labels}

\item{cex}{relative size of the text labels. Eiter one number, a name of a numeric variable in the shape data that is used to scale the sizes proportionally, or \code{AREA} where the text size is proportional to the the area size of the polygons.}

\item{root}{root number to which the font sizes are scaled. Only applicable if \code{cex} is a variable name or \code{"AREA"}. If \code{root=2}, the square root is taken, if \code{root=3} the cube root etc.}

\item{fontcolor}{relative size of the text labels}

\item{fontface}{font face of the text labels}

\item{fontfamily}{font family of the text labels}

\item{case}{case of the font. Use "upper" to generate upper-case text, "lower" to generate lower-case text, and use \code{NA} to leave the text as is.}

\item{bg.color}{background color of the text labels. By default, \code{bg.color=NA}, so no background is drawn.}

\item{bg.alpha}{number between 0 and 255 that specifies the transparancy of the text background (0 is totally transparent, 255 is solid background). The default value is 100.}

\item{cex.lowerbound}{lowerbound for \code{cex}. Needed to ignore the tiny labels in case \code{cex} is a variable.}

\item{print.tiny}{boolean that determines if tiny labels (which size is smaller than \code{cex.lowerbound}) are print at size \code{cex.lowerbound}}

\item{scale}{scalar needed in case cex is based}

\item{xmod}{horizontal position modification of the text, relatively where 0 means no modification, and 1 means the total width of the frame. Either a single number for all polygons, or a numeric variable in the shape data specifying a number for each polygon. Together with \code{ymod}, it determines position modification of the text labels. In most coordinate systems (projections), the origin is located at the bottom left, so negative \code{xmod} move the text to the left, and negative \code{ymod} values to the bottom.}

\item{ymod}{vertical position modification. See xmod.}
}
\value{
\code{\link{tmap-element}}
}
\description{
This layer adds text labels
}
\examples{
# Europe example
data(Europe)
tm_shape(Europe) +
    tm_fill("gdp_cap_est", style="kmeans", textNA = "Non-European countries") +
    tm_borders() +
    tm_text("iso_a3", cex="AREA", scale=2, bg.alpha=0) +
tm_layout_Europe("GDP per capita")


data(rivers)
data(cities)

tm_shape(Europe) +
    tm_fill("pop_est_dens", style="kmeans", textNA="Non-European countries") +
    tm_borders() +
tm_shape(rivers) +
    tm_lines("dodgerblue3") +
tm_shape(cities) +
    tm_text("name", cex="pop_max", scale=1, ymod=-.02, root=4, cex.lowerbound = .60, 
            bg.color="yellow", bg.alpha = 150) + 
    tm_bubbles("pop_max", "red", border.col = "black", border.lwd=1, size.lim = c(0, 2e7)) +
tm_shape(Europe) +
    tm_text("name", cex="area", scale=1.5, root=8, cex.lowerbound = .40, 
            fontface="bold", case=NA, fontcolor = "gray35") + 
tm_layout_Europe("Map of Europe", 
    legend.titles = c(fill="Country population density (people per km2)", 
                      bubble.size="City Population"))
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

