% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_model}
\alias{fit_model}
\title{Fit parametric model for selected subjects}
\usage{
fit_model(dat, reason, impute, imputation_model = c("weibull", "exponential"))
}
\arguments{
\item{dat}{data.frame containing at least 5 columns: TRT01P (treatment arm as factor), AVAL (survival time), EVENT (event indicator), CNSRRS (censoring reason) and MAXAVAL (maximum potential survival time, duration between randomization to data cut-off)}

\item{reason}{a string specifying the censoring reasons which require imputation. It must be one of the reasons from column CNSRRS.}

\item{impute}{a string specifying the treatment arm(s) which require imputation. It must be one of the arms from column TRT01P.}

\item{imputation_model}{a string specifying the parametric distribution used for imputation, can be "Weibull" or "exponential".}
}
\value{
data.frame with flags and fitted model parameters to be used for imputation
}
\description{
Fit parametric model for selected subjects
}
\details{
The data.frame contains original columns, plus the following columns appended:
\tabular{ll}{
AVAL4  \tab Placeholder column to keep imputed survival times \cr
EVENT4 \tab Placeholder column to keep imputed events \cr
impute \tab Flag indicating whether the subject was selected for imputation \cr
a      \tab Shape parameter, equal to 1 if exponential \cr
b      \tab Scale parameter \cr
cdf    \tab Cumulative distribution function \cr
...    \tab Some temporary columns
}
}
\keyword{internal}
