% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tip_coef_with_r2.R
\name{tip_coef_with_r2}
\alias{tip_coef_with_r2}
\title{Tip a regression coefficient using the partial R2
for an unmeasured confounder-exposure relationship and unmeasured confounder-
outcome relationship}
\usage{
tip_coef_with_r2(
  effect_observed,
  se,
  df,
  confounder_exposure_r2 = NULL,
  confounder_outcome_r2 = NULL,
  verbose = TRUE,
  alpha = 0.05,
  tip_bound = FALSE,
  ...
)
}
\arguments{
\item{effect_observed}{Numeric. Observed exposure - outcome effect from a
regression model. This is the point estimate (beta coefficient)}

\item{se}{Numeric. Standard error of the \code{effect_observed} in the previous parameter.}

\item{df}{Numeric positive value. Residual degrees of freedom for the model
used to estimate the observed exposure - outcome effect. This is the total
number of observations minus the number of parameters estimated in your
model. Often for models estimated with an intercept this is N - k - 1
where k is the number of predictors in the model.}

\item{confounder_exposure_r2}{Numeric value between 0 and 1. The assumed partial R2 of
the unobserved confounder with the exposure given the measured covariates.}

\item{confounder_outcome_r2}{Numeric value between 0 and 1. The assumed partial R2 of
the unobserved confounder with the outcome given the exposure and
the measured covariates.}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}

\item{alpha}{Significance level. Default = \code{0.05}.}

\item{tip_bound}{Do you want to tip at the bound? Default = \code{FALSE}, will tip at the point estimate}

\item{...}{Optional arguments passed to the \code{\link[sensemakr:adjusted_estimate]{sensemakr::adjusted_estimate()}}
function.}
}
\value{
A data frame.
}
\description{
Choose one of the following, and the other will be estimated:
\itemize{
\item \code{confounder_exposure_r2}
\item \code{confounder_outcome_r2}
}
}
\examples{
tip_coef_with_r2(0.5, 0.1, 102, 0.5)
}
