% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_tt.R
\name{format_tt}
\alias{format_tt}
\title{Format columns of a data frame}
\usage{
format_tt(
  x,
  i = NULL,
  j = NULL,
  digits = get_option("tinytable_format_digits", default = NULL),
  num_fmt = get_option("tinytable_format_num_fmt", default = "significant"),
  num_zero = get_option("tinytable_format_num_zero", default = FALSE),
  num_suffix = get_option("tinytable_format_num_suffix", default = FALSE),
  num_mark_big = get_option("tinytable_format_num_mark_big", default = ""),
  num_mark_dec = get_option("tinytable_format_num_mark_dec", default =
    getOption("OutDec", default = ".")),
  date = get_option("tinytable_format_date", default = "\%Y-\%m-\%d"),
  bool = get_option("tinytable_format_bool", default = function(column)
    tools::toTitleCase(tolower(column))),
  math = get_option("tinytable_format_math", default = FALSE),
  other = get_option("tinytable_format_other", default = as.character),
  replace = get_option("tinytable_format_replace", default = TRUE),
  escape = get_option("tinytable_format_escape", default = FALSE),
  markdown = get_option("tinytable_format_markdown", default = FALSE),
  quarto = get_option("tinytable_format_quarto", default = FALSE),
  fn = get_option("tinytable_format_fn", default = NULL),
  sprintf = get_option("tinytable_format_sprintf", default = NULL),
  ...
)
}
\arguments{
\item{x}{A data frame or a vector to be formatted.}

\item{i}{Row indices where the formatting should be applied.}

\item{j}{Column indices where the styling should be applied. Can be:
\itemize{
\item Integer vectors indicating column positions.
\item Character vector indicating column names.
\item A single string specifying a Perl-style regular expression used to match column names.
}}

\item{digits}{Number of significant digits or decimal places.}

\item{num_fmt}{The format for numeric values; one of 'significant', 'significant_cell', 'decimal', or 'scientific'.}

\item{num_zero}{Logical; if TRUE, trailing zeros are kept in "decimal" format (but not in "significant" format).}

\item{num_suffix}{Logical; if TRUE display short numbers with \code{digits} significant digits and K (thousands), M (millions), B (billions), or T (trillions) suffixes.}

\item{num_mark_big}{Character to use as a thousands separator.}

\item{num_mark_dec}{Decimal mark character. Default is the global option 'OutDec'.}

\item{date}{A string passed to the \code{format()} function, such as "\%Y-\%m-\%d". See the "Details" section in \code{?strptime}}

\item{bool}{A function to format logical columns. Defaults to title case.}

\item{math}{Logical. If TRUE, wrap cell values in math mode \verb{$..$}. This is useful for LaTeX output or with HTML MathJax \code{options(tinytable_html_mathjax=TRUE)}.}

\item{other}{A function to format columns of other types. Defaults to \code{as.character()}.}

\item{replace}{Logical, String or Named list of vectors
\itemize{
\item TRUE: Replace \code{NA} by an empty string.
\item FALSE: Print \code{NA} as the string "NA".
\item String: Replace \code{NA} entries by the user-supplied string.
\item Named list: Replace matching elements of the vectors in the list by theirs names. Example:
\itemize{
\item \code{list("-" = c(NA, NaN), "Tiny" = -Inf, "Massive" = Inf)}
}
}}

\item{escape}{Logical or "latex" or "html". If TRUE, escape special characters to display them as text in the format of the output of a \code{tt()} table.
\itemize{
\item If \code{i} and \code{j} are both \code{NULL}, escape all cells, column names, caption, notes, and spanning labels created by \code{group_tt()}.
}}

\item{markdown}{Logical; if TRUE, render markdown syntax in cells. Ex: \verb{_italicized text_} is properly italicized in HTML and LaTeX.}

\item{quarto}{Logical. Enable Quarto data processing and wrap cell content in a \code{data-qmd} span (HTML) or \verb{\\QuartoMarkdownBase64\{\}} macro (LaTeX). See warnings in the Global Options section below.}

\item{fn}{Function for custom formatting. Accepts a vector and returns a character vector of the same length.}

\item{sprintf}{String passed to the \code{?sprintf} function to format numbers or interpolate strings with a user-defined pattern (similar to the \code{glue} package, but using Base R).}

\item{...}{Additional arguments are ignored.}
}
\value{
A data frame with formatted columns.
}
\description{
This function formats the columns of a data frame based on the column type (logical, date, numeric).
It allows various formatting options like significant digits, decimal points, and scientific notation.
It also includes custom formatting for date and boolean values.
If this function is applied several times to the same cell, the last transformation is retained and the previous calls are ignored, except for the \code{escape} argument which can be applied to previously transformed data.
}
\section{Global options}{

\subsection{Quarto}{
\subsection{Figure environment}{
\itemize{
\item \code{options("tinytable_quarto_figure" = FALSE)}: Typst only. Normally, it is best to allow Quarto to define the figure environment, so the default behavior is to not include one.
}
}

\subsection{Data Processing}{

The \code{format_tt(quarto=TRUE)} argument activates Quarto data processing for specific cells. This funcationality comes with  a few warnings:
\enumerate{
\item Currently, Quarto provides a \verb{\\QuartoMarkdownBase64\{\}} LaTeX macro, but it does not appear to do anything with it. References and markdown codes may not be processed as expected in LaTeX.
\item Quarto data processing can enter in conflict with \code{tinytable} styling or formatting options. See below for how to disable it.
}

\code{options(tinytable_quarto_disable_processing = TRUE)}

Disable Quarto processing of cell content. Setting this global option to \code{FALSE} may lead to conflicts with some \code{tinytable} features, but it also allows use of markdown and Quarto-specific code in table cells, such as cross-references.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- data.frame(Math = "x^2^", Citation = "@Lovelace1842")
fn <- function(z) sprintf("<span data-qmd='\%s'></span>", z)
tt(x) |> format_tt(i = 1, fn = fn)
}\if{html}{\out{</div>}}

See this link for more details: https://quarto.org/docs/authoring/tables.html#disabling-quarto-table-processing
}

}

\subsection{HTML}{
\itemize{
\item \code{options(tinytable_html_mathjax = TRUE)}: insert MathJax scripts in the HTML document. Warning: This may conflict with other elements of the page if MathJax is otherwise loaded.
\item \code{options(tinytable_html_portable = TRUE)}: \code{plot_tt()} inserts base 64 encoded images directly in the HTML file rather than use external links.
}
}

\subsection{PDF}{
\itemize{
\item \code{options(tinytable_pdf_clean = TRUE)} deletes temporary and log files.
\item \code{options(tinytable_pdf_engine = "xelatex")}: "xelatex", "pdflatex", "lualatex"
}
}
}

\examples{
dat <- data.frame(
  a = rnorm(3, mean = 10000),
  b = rnorm(3, 10000))
tab <- tt(dat)
format_tt(tab,
 digits = 2,
 num_mark_dec = ",",
 num_mark_big = " ")
 
k <- tt(data.frame(x = c(0.000123456789, 12.4356789)))
format_tt(k, digits = 2, num_fmt = "significant_cell")
 
dat <- data.frame(
   a = c("Burger", "Halloumi", "Tofu", "Beans"),
   b = c(1.43202, 201.399, 0.146188, 0.0031),
   c = c(98938272783457, 7288839482, 29111727, 93945))
tt(dat) |>
 format_tt(j = "a", sprintf = "Food: \%s") |>
 format_tt(j = 2, digits = 1, num_fmt = "decimal", num_zero = TRUE) |>
 format_tt(j = "c", digits = 2, num_suffix = TRUE)
 
y <- tt(data.frame(x = c(123456789.678, 12435.6789)))
format_tt(y, digits=3, num_mark_big=" ")

x <- tt(data.frame(Text = c("_italicized text_", "__bold text__")))
format_tt(x, markdown=TRUE)

tab <- data.frame(a = c(NA, 1, 2), b = c(3, NA, 5))
tt(tab) |> format_tt(replace = "-")

dat <- data.frame(
   "LaTeX" = c("Dollars $", "Percent \%", "Underscore _"),
   "HTML" = c("<br>", "<sup>4</sup>", "<emph>blah</emph>")
)
tt(dat) |> format_tt(escape = TRUE)   

}
