% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_inops.R
\name{report_inops}
\alias{report_inops}
\title{Report Infix Operators}
\usage{
report_inops(env)
}
\arguments{
\item{env}{an optional environment to give,
where the function should look for infix operators. \cr
When not specified, the current environment
is used. \cr}
}
\value{
A data.frame.
The first column gives the infix operator names.
The second column gives the package the operator came from,
or NA if it did not come from a package.
}
\description{
The \code{report_inops()} function
returns a data.frame listing the infix operators defined
in the current environment,
or a user specified environment.
It also reports from which packages the infix operators came from.
}
\examples{

report_inops()

`\%paste\%` <- function(x,y)paste0(x,y)

report_inops()

import_inops("stringi")

report_inops()




}
\seealso{
\code{\link[=tinycodet_misc]{tinycodet_misc()}}
}
