% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgs.R
\name{pkgs}
\alias{pkgs}
\alias{\%installed in\%}
\alias{pkg_get_deps}
\alias{pkg_lsf}
\title{Miscellaneous Package Related Functions}
\usage{
pkgs \%installed in\% lib.loc

pkg_get_deps(
  package,
  lib.loc = .libPaths(),
  deps_type = c("LinkingTo", "Depends", "Imports"),
  base = FALSE,
  recom = FALSE,
  rstudioapi = FALSE
)

pkg_lsf(package, type, lib.loc = .libPaths())
}
\arguments{
\item{pkgs}{a character vector with the package name(s).}

\item{lib.loc}{character vector specifying library search path
(the location of R library trees to search through). \cr
The \code{lib.loc} argument would usually be \code{.libPaths()}. \cr
See also \link[base]{loadNamespace}.}

\item{package}{a single string giving the package name.}

\item{deps_type}{a character vector, giving the dependency types to be used. \cr
Defaults to \code{c("LinkingTo", "Depends", "Imports")}. \cr
The order of the character vector given in \code{deps_type} affects
the order of the returned character vector; see Details sections.}

\item{base}{logical,
indicating whether base/core R should be included (\code{TRUE}),
or not included (\code{FALSE}; the default).}

\item{recom}{logical,
indicating whether the pre-installed "recommended" R-packages should be included (\code{TRUE}),
or not included (\code{FALSE}; the default).}

\item{rstudioapi}{logical,
indicating whether the \code{rstudioapi} R-package should be included (\code{TRUE}),
or not included (\code{FALSE}; the default).}

\item{type}{The type of functions to list. Possibilities:
\itemize{
\item \code{"inops"} or \code{"operators"}: Only infix operators.
\item \code{"regfuns"}: Only regular functions (thus excluding infix operators).
\item \code{"all"}: All functions, both regular functions and infix operators.
}}
}
\value{
For  \code{pkgs \%installed in\% lib.loc}: \cr
Returns a named logical vector, with the names giving the package names,
and where the value \code{TRUE} indicates a package is installed,
and the value \code{FALSE} indicates a package is not installed. \cr
\cr
For \code{pkg_get_deps()}: \cr
A character vector of unique dependencies. \cr
\cr
For \code{pkg_lsf()}: \cr
Returns a character vector of exported function names in the specified package.
}
\description{
The \code{pkgs \%installed in\% lib.loc} operator
checks if one or more package(s) \code{pkgs} exist(s)
in library location \code{lib.loc}, without loading the package(s). \cr
The syntax of this operator forces the user to make it
syntactically explicit
where to look for installed R-package(s). \cr
As \code{pkgs \%installed in\% lib.loc} does not even load a package,
the user can safely use it
without fearing any unwanted side-effects. \cr
\cr
The \code{pkg_get_deps()} function gets the dependencies of a package
from the Description file. It works on non-CRAN packages also. \cr
\cr
The \code{pkg_lsf()} function
gets a list of exported functions/operators from a package. \cr
One handy use for this function is to, for example,
globally attach all infix operators from a function using \code{library},
like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(packagename, include.only = pkg_lsf("packagename", type="inops"))
}\if{html}{\out{</div>}}
}
\details{
For \code{pkg_get_deps()}: \cr
If using the \code{pkgs_get_deps()} function
to fill in the \code{dependencies} argument of the \link{import_as} function,
one may want to know the how character vector returned by \code{pkgs_get_deps()} is ordered. \cr
The order is determined as follows. \cr
For each string in argument \code{deps_type},
the package names in the corresponding field of the Description file are extracted,
in the order as they appear in that field. \cr
The order given in argument \code{deps_type}
also affects the order of the returned character vector: \cr
The default, \cr
\code{c("LinkingTo", "Depends", "Imports")}, \cr
means the package names are extracted from the fields in the following order:

\enumerate{
\item "LinkingTo";
\item "Depends";
\item "Imports".
}
The unique (thus non-repeating) package names are then returned to the user.
}
\examples{

check <- "dplyr" \%installed in\% .libPaths()

if(check) pkgs <- pkg_get_deps("dplyr") # many dependencies
if(check) pkgs \%installed in\% .libPaths()
if(check) pkg_lsf("dplyr", "all")




}
\references{
O'Brien J., elegantly extract R-package dependencies of a package not listed on CRAN. \emph{Stack Overflow}. (1 September 2023). \url{https://stackoverflow.com/questions/30223957/elegantly-extract-r-package-dependencies-of-a-package-not-listed-on-cran}
}
\seealso{
\code{\link[=tinycodet_import]{tinycodet_import()}}
}
