% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{Ops}
\alias{Ops}
\alias{+}
\alias{-}
\alias{*}
\alias{/}
\alias{\%\%}
\alias{\%/\%}
\alias{==}
\alias{!=}
\alias{<}
\alias{<=}
\alias{>}
\alias{>=}
\alias{!}
\alias{Ops.tind}
\alias{\%+y\%}
\alias{\%-y\%}
\alias{\%+q\%}
\alias{\%-q\%}
\alias{\%+m\%}
\alias{\%-m\%}
\alias{\%+w\%}
\alias{\%-w\%}
\alias{\%+d\%}
\alias{\%-d\%}
\alias{\%+h\%}
\alias{\%-h\%}
\alias{\%+min\%}
\alias{\%-min\%}
\alias{\%+s\%}
\alias{\%-s\%}
\title{Operations Involving Time Indices, Time Differences, and Time Intervals}
\usage{
\method{Ops}{tind}(e1, e2)

e1 \%+y\% e2

e1 \%-y\% e2

e1 \%+q\% e2

e1 \%-q\% e2

e1 \%+m\% e2

e1 \%-m\% e2

e1 \%+w\% e2

e1 \%-w\% e2

e1 \%+d\% e2

e1 \%-d\% e2

e1 \%+h\% e2

e1 \%-h\% e2

e1 \%+min\% e2

e1 \%-min\% e2

e1 \%+s\% e2

e1 \%-s\% e2
}
\arguments{
\item{e1, e2}{a \code{tind}, \code{tdiff}, \code{tinterval}, or a numeric vector.}
}
\value{
Comparison operators and \code{!} return logical vectors.

Differences of time indices are returned as objects of \code{tdiff} class,
except for arguments of type \code{"i"} or \code{"n"} (integer/numeric
indices), in which case an integer or numeric vector is returned.

Shifting time indices and time intervals produces time indices and time
intervals, respectively.

Operations involving time differences return time differences.
}
\description{
Basic arithmetic and comparison operators are implemented
for time indices, time differences, and time intervals where applicable.

Operators \code{+} and \code{-} allow for shifting
time indices and computing differences between two indices. Time intervals
can be shifted using these, too. When the second operand in \code{+} and \code{-}
is numeric the underlying time unit is used. For time of day and date-time indices
this is always a second.

Convenience operators
\code{\%+y\%}, \code{\%-y\%},  \code{\%+q\%}, \code{\%-q\%},
\code{\%+m\%}, \code{\%-m\%}, \code{\%+w\%}, \code{\%-w\%},
\code{\%+d\%}, \code{\%-d\%}, \code{\%+h\%}, \code{\%-h\%},
\code{\%+min\%}, \code{\%-min\%}, \code{\%+s\%}, and \code{\%-s\%}
can used to shift time indices (and intervals) by years, quarters, months,
weeks, days, hours minutes, and seconds.
See Details for their behaviour in corner cases.

For all index types except for integer and numeric indices differences
between time indices are retuned as objects of \code{tdiff} class.

Comparison operators are available for time indices (\code{tind})
and time differences (\code{tdiff}).
}
\details{
One can only subtract from time indices and divide time differences.

Unary \code{+} and \code{-} operators are supported for \code{tdiff} only.

Results of arithmetic operations are always validated and can become \code{NA}s
(when out of range) or be rounded, for example, when dividing
time differences in days by numbers that are not divisors.

Shifting time intervals beyond valid index ranges can lead to spurious results
as beginnings or ends of time intervals become \code{NA}s and intervals can become
entire line.

\code{==} and \code{!=} operators for time indices only accept same types
of indices. The remaining comparison operators accept different types
provided that conversion can be performed.

\strong{Corner Cases}

When shifting dates by months one is faced with a dilemma:
should month after March 31st be April 30th or May 1st?
The convention in \pkg{tind} is that the result of \code{\%+m\% n}
always falls in the \code{n}th month after the month in which
a given date falls and in corner cases the last day in the resulting
month is returned. Similar logic is applied to shifts by years
and quarters as well as shifts of weeks by years (some years have 53 weeks).
See Examples.

Shifting date-time indices by days can also be problematic in front of DST changes,
when the resulting date has 23 hours (one hour missing) or 25 hours
(one hour repeated). When hour is missing, the next hour is selected (no \code{NA}
is returned). When hour is doubled, the second occurrence
is selected. See Examples.
}
\examples{
# list the last 10 days including today
today() + (-9:0)

# how many days have passed since the beginning of the year?
today() - floor_t(today(), "y")
# same but the result is not tdiff
day_of_year(today()) - 1

# single time interval
x <- "2024-06-01 08:00" \%--\% "2024-06-01 16:00"
# shift by 0, 1, ..., 5 days
x \%+d\% 0:5

# are we in or after 2026?
today() >= 2026
# are we after 2025?
today() > 2025

# corner cases - ends of months and shifts by months
as.date("2024-01-31") \%+m\% 0:5
# same
as.date("2024-01-31") + mnths(0:5)

# corner cases - 53rd week of year
as.week(202053) \%-y\% 0:5

# corner cases - DST changes and shifts by days
if ("Europe/Warsaw" \%in\% OlsonNames()) {
    # 2020-10-25 had 25h with 02:00 repeated
    print(as.date_time("2020-10-24 02:00", tz = "Europe/Warsaw") \%+h\% 23:26)
    print(as.date_time("2020-10-24 02:00", tz = "Europe/Warsaw") \%+d\% 1)
    print(as.date_time("2020-10-26 02:00", tz = "Europe/Warsaw") \%-h\% 26:23)
    print(as.date_time("2020-10-26 02:00", tz = "Europe/Warsaw") \%-d\% 1)
    # 2021-03-28 had 23h with 02:00 missing
    print(as.date_time("2021-03-27 02:00", tz = "Europe/Warsaw") \%+h\% 22:25)
    print(as.date_time("2021-03-27 02:00", tz = "Europe/Warsaw") \%+d\% 1)
    print(as.date_time("2021-03-29 02:00", tz = "Europe/Warsaw") \%-h\% 25:22)
    print(as.date_time("2021-03-29 02:00", tz = "Europe/Warsaw") \%-d\% 1)
}

}
\seealso{
\code{\link{tind}} class and its constructor,
\code{\link{calendrical-computations}} for calendrical computations.
}
