% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{ti_type}
\alias{ti_type}
\alias{ti_type.tind}
\alias{ti_type.Date}
\alias{ti_type.POSIXt}
\alias{is.instant}
\title{Get Time Index Type}
\usage{
ti_type(x, long = TRUE, valid = FALSE)

\method{ti_type}{tind}(x, long = TRUE, valid = FALSE)

\method{ti_type}{Date}(x, long = TRUE, valid = FALSE)

\method{ti_type}{POSIXt}(x, long = TRUE, valid = FALSE)

is.instant(x)
}
\arguments{
\item{x}{an object of \code{tind} class or an object coercible to it.}

\item{long}{a logical value, if \code{FALSE}, internal single-character code
of index type is returned; if \code{TRUE}, long (human-readable)
name is returned (\code{TRUE} by default).}

\item{valid}{a logical value, if \code{TRUE}, syntactically valid names
will be returned (\code{FALSE} by default).}
}
\value{
A character value for \code{ti_type}, a logical value
for \code{is.instant}.
}
\description{
\code{ti_type} method returns time index type as a character value, either
in short form (single letter, code used internally) or long form (name).

\code{is.instant} returns \code{TRUE} for continuous time indices representing
points in time (date-time, time of day, and numeric indices) and \code{FALSE}
for time discrete indices that represent periods of time, for example, days representing
(usually) 24 hours, weeks, months, quarter, and years (as well as integer indices).
}
\note{
Behaviour of \code{is.instant} differs from that of identically named
function in \pkg{lubridate} package, which returns \code{TRUE} for all time
classes including dates.
}
\examples{
ti_type(as.tind(1999))
ti_type(as.tind(1999), FALSE)
ti_type(as.tind("2001q3"))
ti_type(as.tind("2001q3"), FALSE)
ti_type(as.tind("2003-11"))
ti_type(as.tind("2003-11"), FALSE)
ti_type(as.tind("2004-W53"))
ti_type(as.tind("2004-W53"), FALSE)
ti_type(as.tind("2020-02-29"))
ti_type(as.tind("2020-02-29"), FALSE)
ti_type(today())
ti_type(today(), FALSE)
is.instant(today())
ti_type(now())
ti_type(now(), FALSE)
is.instant(now())
ti_type(Sys.Date())
ti_type(Sys.Date(), FALSE)
is.instant(Sys.Date())
ti_type(Sys.time())
ti_type(Sys.time(), FALSE)
is.instant(Sys.time())

}
\seealso{
\code{\link{t_unit}}.
}
