% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-scales.R
\name{scale_tind}
\alias{scale_tind}
\alias{scale_x_tind}
\alias{scale_y_tind}
\title{Time Scales for Plotting with \pkg{ggplot2}}
\usage{
scale_x_tind(
  name = ggplot2::waiver(),
  breaks = ggplot2::waiver(),
  minor_breaks = ggplot2::waiver(),
  n.breaks = 7L,
  labels = ggplot2::waiver(),
  limits = NULL,
  expand = ggplot2::waiver(),
  guide = ggplot2::waiver(),
  position = "bottom",
  format = NULL,
  locale = NULL
)

scale_y_tind(
  name = ggplot2::waiver(),
  breaks = ggplot2::waiver(),
  minor_breaks = ggplot2::waiver(),
  n.breaks = 7L,
  labels = ggplot2::waiver(),
  limits = NULL,
  expand = ggplot2::waiver(),
  guide = ggplot2::waiver(),
  position = "left",
  format = NULL,
  locale = NULL
)
}
\arguments{
\item{name}{a character string with axis name, \code{waiver()} for default
name, or \code{NULL} for none.}

\item{breaks}{\code{waiver()} for default tick-marks, \code{NULL} for none,
time indices at which tick-marks should be placed (\code{tind}),
or a \code{tdiff} / character string determining distance between
breaks.}

\item{minor_breaks}{\code{waiver()} for default minor tick-marks,
\code{NULL} for none, or time indices at which minor
tick-marks should be placed.}

\item{n.breaks}{an integer value, desired number of breaks.}

\item{labels}{\code{waiver()} for default labels, \code{NULL} for none,
or a character vector of labels.}

\item{limits}{\code{NULL} for automatic limits, \code{tinterval} of length 1
or \code{tind} of length 2.}

\item{expand, guide}{see \link[ggplot2]{scale_continuous}.}

\item{position}{a character string determining axis position,
\code{"bottom"} or \code{"top"} for \code{scale_x_tind},
\code{"left"} or \code{"right"} for \code{scale_y_tind}.}

\item{format}{(optional) a character string determining label format
(see \code{\link{format}}) or a formatting function.}

\item{locale}{(optional) a character string determining locale to be used
for formatting labels, see \link{calendar-names} for information
on locale settings.}
}
\value{
A continuous scale as returned by \code{\link[ggplot2]{continuous_scale}}.
}
\description{
These functions provide \pkg{ggplot2} scales for \code{tind}. Scales will
be added automatically by \pkg{ggplot2}, but the default behaviour
can be overridden by adding \code{scale_*_tind} to the plot.
}
\details{
The algorithm determining positioning of breaks and minor breaks always takes
the resolution of time indices (see \code{\link{resolution_t}}) into account.
For example, for monthly data with breaks placed every three months (January,
April, July, October) minor breaks will never be placed in the middle (mid of
February, May, August, November) but rather every month. The algorithm
overrides the default approach of \pkg{ggplot2} --- axis limits are determined
based on breaks and breaks on time indices and their resolution, whereas
\pkg{ggplot2} starts with limits based on data and determines breaks based
on limits only (ignoring the resolution of time indices).

Argument list is a bit different from that of to \code{scale_*_date} and
\code{scale_*_datetime}. Firstly, \code{n.breaks} argument is supported,
allowing users to set the expected number of breaks on time axis. Secondly,
\code{labels} cannot be a function. Formatting functions can be provided via
\code{format} argument, which also supports character string with format
specification (see \code{\link{format}}) rendering \code{date_labels}
argument redundant. \code{locale} argument controls the language used
for month and weekday names, see \link{calendar-names}.
\code{breaks} cannot be a function, but can be a \code{tdiff} / character string
determining distance between breaks rendering \code{date_breaks} argument
redundant. \code{limits} argument is expected to determine time interval
and not limits in Cartesian coordinates. Open-ended intervals are supported.

\code{breaks}, \code{minor_breaks}, and \code{limits} cannot be functions
as \pkg{ggplot2} assumes that breaks and limits can be properly set based
on (automatic) limits only without taking into account the resolution of time
indices, which is not true.

Secondary axes are not supported.
}
\note{
Due to the fact that \code{\link[ggplot2]{limits}} method is currently
(as of version 4.0.0) not exported, users cannot use \code{xlim} and
\code{ylim} with \code{tind} scales. Limits on time-indexed axes can be set
using \code{limits} argument to \code{scale_*_tind}.
}
\examples{
\donttest{
# load ggplot2
library(ggplot2)
# artificial data
d <- seq(floor_t(today(), "y"), ceiling_t(today(), "y", ceiling = "last"))
df <- data.frame(d = d, D = as.Date(d), y = cumsum(rnorm(length(d))),
                 q = paste0("Q", quarter(d)))
# default scale
ggplot(df) + geom_line(aes(x = d, y = y)) + theme_bw()
# compare with the default scale for Date
ggplot(df) + geom_line(aes(x = D, y = y)) + theme_bw()
# change format
ggplot(df) + geom_line(aes(x = d, y = y)) + theme_bw() +
    scale_x_tind(format = "\%b '\%y")
# set breaks every 4 months
ggplot(df) + geom_line(aes(x = d, y = y)) + theme_bw() +
    scale_x_tind(breaks = "4m")
# set limits
ggplot(df) + geom_line(aes(x = d, y = y), na.rm = TRUE) + theme_bw() +
    scale_x_tind(limits = c(today() \%-m\% 4, today()))
# facets with custom formatting and reduced number of breaks
ggplot(df) + geom_line(aes(x = d, y = y)) + theme_bw() +
    scale_x_tind(n.breaks = 4, format = "\%b '\%y") +
    facet_wrap(~q, scales = "free_x")
}

}
\seealso{
\code{\link{pretty}} for computing pretty breakpoints,
\code{\link{axis_t}} for computing time axis parameters,
\code{\link{axis.tind}} for creating axes with \pkg{graphics} package.
}
