% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsample-time_series_cv.R
\name{time_series_cv}
\alias{time_series_cv}
\title{Time Series Cross Validation}
\usage{
time_series_cv(
  data,
  initial = 5,
  assess = 1,
  cumulative = TRUE,
  skip = 0,
  lag = 0,
  slice_limit = n(),
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{initial}{The number of samples used for analysis/modeling in the
initial resample.}

\item{assess}{The number of samples used for each assessment resample.}

\item{cumulative}{A logical. Should the analysis resample grow beyond the
size specified by \code{initial} at each resample?.}

\item{skip}{A integer indicating how many (if any) \emph{additional} resamples
to skip to thin the total amount of data points in the analysis resample.
See the example below.}

\item{lag}{A value to include an lag between the assessment
and analysis set. This is useful if lagged predictors will be used
during training and testing.}

\item{slice_limit}{The number of slices to return. Set to \code{dplyr::n()},
which returns the maximum number of slices.}

\item{...}{Not currently used.}
}
\value{
An tibble with classes \code{time_series_cv}, \code{rset}, \code{tbl_df}, \code{tbl},
and \code{data.frame}. The results include a column for the data split objects
and a column called \code{id} that has a character string with the resample
identifier.
}
\description{
Create \code{rsample} cross validation sets for time series.
This function produces a sampling plan starting with the most recent
time series observations, rolling backwards. The sampling procedure
is similar to \code{rsample::rolling_origin()}, but places the focus
of the cross validation on the most recent time series data.
}
\details{
\strong{Intial (Training Set) and Assess (Testing Set)}

The main options, \code{initial} and \code{assess}, control the number of
data points from the original data that are in the analysis (training set)
and the assessment (testing set), respectively.

\strong{Cumulative vs Sliding Window}

When \code{cumulative = TRUE}, the \code{initial} parameter is ignored and the
analysis (training) set will grow as
resampling continues while the assessment (testing) set size will always remain
static.

When \code{cumulative = FALSE}, the \code{initial} parameter fixes the analysis (training)
set and resampling occurs over a fixed window.

\strong{Skip}

\code{skip} enables the function to not use every data point in the resamples.
When \code{skip = 0}, the resampling data sets will increment by one position.
Suppose that the rows of a data set are consecutive days. Using \code{skip = 6}
will make the analysis data set operate on \emph{weeks} instead of days. The
assessment set size is not affected by this option.

\strong{Lag}

The Lag parameter creates an overlap between the Testing set. This is needed
when lagged predictors are used.

\strong{Slice Limit}

This controls the number of slices. If \code{slice_limit = 5}, only the most recent
5 slices will be returned.
}
\examples{
library(tidyverse)
library(tidyquant)
library(rsample)
library(timetk)

FB_tbl <- FANG \%>\%
    filter(symbol == "FB") \%>\%
    select(symbol, date, adjusted)

resample_spec <- time_series_cv(
    FB_tbl,
    initial = 150, assess = 50, skip = 50,
    cumulative = FALSE,
    lag = 30,
    slice_limit = 6)

resample_spec \%>\%
    plot_time_series_cv_plan(
        date, adjusted,
        .facet_ncol = 2,
        .line_alpha = 0.5,
        .interactive = FALSE
    )

}
\seealso{
\itemize{
\item \code{\link[=time_series_cv]{time_series_cv()}} and \code{\link[rsample:rolling_origin]{rsample::rolling_origin()}} - Functions used to create
time series resample specfications.
\item \code{\link[=plot_time_series_cv_plan]{plot_time_series_cv_plan()}} - The plotting function used for visualizing the
time series resample plan.
}
}
