% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new.aalen.r
\name{aalen}
\alias{aalen}
\title{Fit additive hazards model}
\usage{
aalen(formula = formula(data), data = sys.parent(), start.time = 0,
  max.time = NULL, robust = 1, id = NULL, clusters = NULL,
  residuals = 0, n.sim = 1000, weighted.test = 0, covariance = 0,
  resample.iid = 0, deltaweight = 1, silent = 1, weights = NULL,
  max.clust = 1000, gamma = NULL, offsets = 0, caseweight = NULL)
}
\arguments{
\item{formula}{a formula object with the response on the left of a '~'
operator, and the independent terms on the right as regressors.The response
must be a survival object as returned by the `Surv' function. Time-
invariant regressors are specified by the wrapper const(), and cluster
variables (for computing robust variances) by the wrapper cluster().}

\item{data}{a data.frame with the variables.}

\item{start.time}{start of observation period where estimates are computed.}

\item{max.time}{end of observation period where estimates are computed.
Estimates thus computed from [start.time, max.time]. Default is max of data.}

\item{robust}{to compute robust variances and construct processes for
resampling. May be set to 0 to save memory.}

\item{id}{For timevarying covariates the variable must associate each record
with the id of a subject.}

\item{clusters}{cluster variable for computation of robust variances.}

\item{residuals}{to returns residuals that can be used for model validation
in the function cum.residuals}

\item{n.sim}{number of simulations in resampling.}

\item{weighted.test}{to compute a variance weighted version of the
test-processes used for testing time-varying effects.}

\item{covariance}{to compute covariance estimates for nonparametric terms
rather than just the variances.}

\item{resample.iid}{to return i.i.d. representation for nonparametric and
parametric terms.}

\item{deltaweight}{uses weights to estimate semiparametric model, under
construction, default=1 is standard least squares estimates}

\item{silent}{set to 0 to print warnings for non-inverible design-matrices
for different timepoints, default is 1.}

\item{weights}{weights for estimating equations.}

\item{max.clust}{sets the total number of i.i.d. terms in i.i.d.
decompostition. This can limit the amount of memory used by coarsening the
clusters. When NULL then all clusters are used.  Default is 1000 to save
memory and time.}

\item{gamma}{fixes gamme at this value for estimation.}

\item{offsets}{offsets for the additive model, to make excess risk
modelling.}

\item{caseweight}{caseweight: mutiplied onto dN for score equations.}
}
\value{
returns an object of type "aalen". With the following arguments:
\item{cum}{cumulative timevarying regression coefficient estimates are
computed within the estimation interval. } \item{var.cum}{the martingale
based pointwise variance estimates for cumulatives.}
\item{robvar.cum}{robust pointwise variances estimates for cumulatives.}
\item{gamma}{estimate of parametric components of model.  }
\item{var.gamma}{variance for gamma.  } \item{robvar.gamma}{robust variance
for gamma.  } \item{residuals}{list with residuals. Estimated martingale
increments (dM) and corresponding time vector (time).}
\item{obs.testBeq0}{observed absolute value of supremum of cumulative
components scaled with the variance.} \item{pval.testBeq0}{p-value for
covariate effects based on supremum test.} \item{sim.testBeq0}{resampled
supremum values.} \item{obs.testBeqC}{observed absolute value of supremum of
difference between observed cumulative process and estimate under null of
constant effect.} \item{pval.testBeqC}{p-value based on resampling.}
\item{sim.testBeqC}{resampled supremum values.}
\item{obs.testBeqC.is}{observed integrated squared differences between
observed cumulative and estimate under null of constant effect.}
\item{pval.testBeqC.is}{p-value based on resampling.}
\item{sim.testBeqC.is}{resampled supremum values.}
\item{conf.band}{resampling based constant to construct robust 95\% uniform
confidence bands. } \item{test.procBeqC}{observed test-process of difference
between observed cumulative process and estimate under null of constant
effect over time.  } \item{sim.test.procBeqC}{list of 50 random realizations
of test-processes under null based on resampling.}
\item{covariance}{covariances for nonparametric terms of model.}
\item{B.iid}{Resample processes for nonparametric terms of model.}
\item{gamma.iid}{Resample processes for parametric terms of model.}
\item{deviance}{Least squares of increments.}
}
\description{
Fits both the additive hazards model of Aalen and the semi-parametric
additive hazards model of McKeague and Sasieni.  Estimates are un-weighted.
Time dependent variables and counting process data (multiple events per
subject) are possible.
}
\details{
Resampling is used for computing p-values for tests of time-varying effects.

The modelling formula uses the standard survival modelling given in the
\bold{survival} package.

The data for a subject is presented as multiple rows or 'observations', each
of which applies to an interval of observation (start, stop].  For counting
process data with the )start,stop] notation is used, the 'id' variable is
needed to identify the records for each subject. The program assumes that
there are no ties, and if such are present random noise is added to break
the ties.
}
\examples{

data(sTRACE)
# Fits Aalen model 
out<-aalen(Surv(time,status==9)~age+sex+diabetes+chf+vf,
sTRACE,max.time=7,n.sim=100)

summary(out)
par(mfrow=c(2,3))
plot(out)

# Fits semi-parametric additive hazards model 
out<-aalen(Surv(time,status==9)~const(age)+const(sex)+const(diabetes)+chf+vf,
sTRACE,max.time=7,n.sim=100)

summary(out)
par(mfrow=c(2,3))
plot(out)

## Excess risk additive modelling 
data(mela.pop)
dummy<-rnorm(nrow(mela.pop));

# Fits Aalen model  with offsets 
out<-aalen(Surv(start,stop,status==1)~age+sex+const(dummy),
mela.pop,max.time=7,n.sim=100,offsets=mela.pop$rate,id=mela.pop$id,
gamma=0)
summary(out)
par(mfrow=c(2,3))
plot(out,main="Additive excess riks model")

# Fits semi-parametric additive hazards model  with offsets 
out<-aalen(Surv(start,stop,status==1)~age+const(sex),
mela.pop,max.time=7,n.sim=100,offsets=mela.pop$rate,id=mela.pop$id)
summary(out)
plot(out,main="Additive excess riks model")

}
\references{
Martinussen and Scheike, Dynamic Regression Models for Survival
Data, Springer (2006).
}
\author{
Thomas Scheike
}
\keyword{survival}
