% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{getPopularMutationCount}
\alias{getPopularMutationCount}
\title{Find Frequent Sequences' Mutation Counts}
\usage{
getPopularMutationCount(sample_db, germline_db, gene_min = 0.001,
  seq_min = 50, seq_p_of_max = 1/8, full_return = FALSE)
}
\arguments{
\item{sample_db}{A Change-O db data frame. See
\link{findNovelAlleles} for a list of required
columns.}

\item{germline_db}{A named list of IMGT-gapped germline sequences.}

\item{gene_min}{The portion of all unique sequences a gene must
constitute to avoid exclusion.}

\item{seq_min}{The number of copies of the V that must be present for
to avoid exclusion.}

\item{seq_p_of_max}{For each gene, fraction of the most common V sequence's
count that a sequence must meet to avoid exclusion.}

\item{full_return}{If true, will return all \code{sample_db} columns and
will include sequences with mutation count < 1.}
}
\value{
A data frame of genes that have a frequent sequence mutation count
         above 1.
}
\description{
\code{getPopularMutationCount} determines which sequences occur frequently
for each V gene and returns the mutation count of those sequences.
}
\examples{
data(sample_db, germline_ighv)
getPopularMutationCount(sample_db, germline_ighv)

}
\seealso{
\link{getMutatedPositions} can be used to find which positions
         of a set of sequences are mutated.
}

